/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.UIIcons;
import org.eclipse.egit.ui.UIText;
import org.eclipse.egit.ui.internal.clone.ProjectRecord;
import org.eclipse.egit.ui.internal.commit.RepositoryCommit;
import org.eclipse.egit.ui.internal.repository.tree.RefNode;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryTreeNodeType;
import org.eclipse.egit.ui.internal.synchronize.model.GitModelBlob;
import org.eclipse.egit.ui.internal.synchronize.model.GitModelCache;
import org.eclipse.egit.ui.internal.synchronize.model.GitModelCommit;
import org.eclipse.egit.ui.internal.synchronize.model.GitModelObject;
import org.eclipse.egit.ui.internal.synchronize.model.GitModelRepository;
import org.eclipse.egit.ui.internal.synchronize.model.GitModelTree;
import org.eclipse.egit.ui.internal.synchronize.model.GitModelWorkingTree;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jgit.lib.BranchTrackingStatus;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryState;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class GitLabelProvider
extends LabelProvider
implements DelegatingStyledCellLabelProvider.IStyledLabelProvider {
    private ResourceManager imageCache;
    private LabelProvider workbenchLabelProvider;

    public static String formatBranchTrackingStatus(BranchTrackingStatus status) {
        StringBuilder sb = new StringBuilder();
        int ahead = status.getAheadCount();
        int behind = status.getBehindCount();
        if (ahead != 0) {
            sb.append('\u2191');
            sb.append(ahead);
        }
        if (behind != 0) {
            if (sb.length() != 0) {
                sb.append(' ');
            }
            sb.append('\u2193');
            sb.append(status.getBehindCount());
        }
        return sb.toString();
    }

    public String getText(Object element) {
        if (element instanceof Repository) {
            return this.getSimpleTextFor((Repository)element);
        }
        if (element instanceof RefNode) {
            return this.getSimpleTextFor((RefNode)element);
        }
        if (element instanceof Ref) {
            return ((Ref)element).getName();
        }
        if (element instanceof ProjectRecord) {
            return ((ProjectRecord)element).getProjectLabel();
        }
        if (element instanceof GitModelObject) {
            return ((GitModelObject)((Object)element)).getName();
        }
        return super.getText(element);
    }

    public Image getImage(Object element) {
        if (element instanceof Repository) {
            return RepositoryTreeNodeType.REPO.getIcon();
        }
        if (element instanceof RefNode || element instanceof Ref) {
            return RepositoryTreeNodeType.REF.getIcon();
        }
        if (element instanceof GitModelBlob || element instanceof GitModelTree) {
            Object adapter = ((IAdaptable)element).getAdapter(IResource.class);
            return this.getWorkbenchLabelProvider().getImage(adapter);
        }
        if (element instanceof GitModelCommit || element instanceof GitModelCache || element instanceof GitModelWorkingTree || element instanceof RepositoryCommit) {
            return this.getChangesetIcon();
        }
        if (element instanceof GitModelRepository) {
            return this.getImage(((GitModelRepository)element).getRepository());
        }
        if (element instanceof ProjectRecord) {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_PROJECT");
        }
        return super.getImage(element);
    }

    public StyledString getStyledText(Object element) {
        try {
            if (element instanceof Repository) {
                return this.getStyledTextFor((Repository)element);
            }
            if (element instanceof GitModelRepository) {
                return this.getStyledTextFor(((GitModelRepository)element).getRepository());
            }
        }
        catch (IOException e) {
            Activator.logError(NLS.bind((String)UIText.GitLabelProvider_UnableToRetrieveLabel, (Object)element.toString()), e);
        }
        return new StyledString(this.getText(element));
    }

    protected StyledString getStyledTextFor(Repository repository) throws IOException {
        File directory = repository.getDirectory();
        StyledString string = new StyledString();
        if (!repository.isBare()) {
            string.append(directory.getParentFile().getName());
        } else {
            string.append(directory.getName());
        }
        String branch = Activator.getDefault().getRepositoryUtil().getShortBranch(repository);
        if (branch != null) {
            BranchTrackingStatus trackingStatus;
            string.append(' ');
            string.append('[', StyledString.DECORATIONS_STYLER);
            string.append(branch, StyledString.DECORATIONS_STYLER);
            RepositoryState repositoryState = repository.getRepositoryState();
            if (repositoryState != RepositoryState.SAFE) {
                string.append(" - ", StyledString.DECORATIONS_STYLER);
                string.append(repositoryState.getDescription(), StyledString.DECORATIONS_STYLER);
            }
            if ((trackingStatus = BranchTrackingStatus.of((Repository)repository, (String)branch)) != null && (trackingStatus.getAheadCount() != 0 || trackingStatus.getBehindCount() != 0)) {
                String formattedTrackingStatus = GitLabelProvider.formatBranchTrackingStatus(trackingStatus);
                string.append(' ');
                string.append(formattedTrackingStatus, StyledString.DECORATIONS_STYLER);
            }
            string.append(']', StyledString.DECORATIONS_STYLER);
        }
        string.append(" - ", StyledString.QUALIFIER_STYLER);
        string.append(directory.getAbsolutePath(), StyledString.QUALIFIER_STYLER);
        return string;
    }

    protected Image getChangesetIcon() {
        return this.getImageCache().createImage(UIIcons.CHANGESET);
    }

    private LabelProvider getWorkbenchLabelProvider() {
        if (this.workbenchLabelProvider == null) {
            this.workbenchLabelProvider = new WorkbenchLabelProvider();
        }
        return this.workbenchLabelProvider;
    }

    private ResourceManager getImageCache() {
        if (this.imageCache == null) {
            this.imageCache = new LocalResourceManager(JFaceResources.getResources());
        }
        return this.imageCache;
    }

    private String getSimpleTextFor(RefNode refNode) {
        return ((Ref)refNode.getObject()).getName();
    }

    private String getSimpleTextFor(Repository repository) {
        File directory = !repository.isBare() ? repository.getDirectory().getParentFile() : repository.getDirectory();
        StringBuilder sb = new StringBuilder();
        sb.append(directory.getName());
        sb.append(" - ");
        sb.append(directory.getAbsolutePath());
        return sb.toString();
    }

    public void dispose() {
        super.dispose();
        if (this.imageCache != null) {
            this.imageCache.dispose();
        }
        if (this.workbenchLabelProvider != null) {
            this.workbenchLabelProvider.dispose();
        }
    }
}

