/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.lttng2.kernel.ui.views.controlflow;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.linuxtools.internal.lttng2.kernel.ui.Messages;
import org.eclipse.linuxtools.internal.lttng2.kernel.ui.views.controlflow.ControlFlowEntry;
import org.eclipse.linuxtools.internal.lttng2.kernel.ui.views.controlflow.ControlFlowEvent;
import org.eclipse.linuxtools.tmf.core.exceptions.AttributeNotFoundException;
import org.eclipse.linuxtools.tmf.core.exceptions.StateValueTypeException;
import org.eclipse.linuxtools.tmf.core.exceptions.TimeRangeException;
import org.eclipse.linuxtools.tmf.core.interval.ITmfStateInterval;
import org.eclipse.linuxtools.tmf.core.statesystem.IStateSystemQuerier;
import org.eclipse.linuxtools.tmf.core.statevalue.ITmfStateValue;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.StateItem;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.TimeGraphPresentationProvider;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.model.ITimeEvent;
import org.eclipse.swt.graphics.RGB;

public class ControlFlowPresentationProvider
extends TimeGraphPresentationProvider {
    public String getStateTypeName() {
        return Messages.ControlFlowView_stateTypeName;
    }

    public StateItem[] getStateTable() {
        StateItem[] stateTable = new StateItem[State.values().length];
        int i = 0;
        while (i < stateTable.length) {
            State state = State.values()[i];
            stateTable[i] = new StateItem(state.rgb, state.toString());
            ++i;
        }
        return stateTable;
    }

    public int getStateTableIndex(ITimeEvent event) {
        if (event instanceof ControlFlowEvent) {
            int status = ((ControlFlowEvent)event).getStatus();
            if (status == 1) {
                return State.WAIT.ordinal();
            }
            if (status == 2) {
                return State.USERMODE.ordinal();
            }
            if (status == 3) {
                return State.SYSCALL.ordinal();
            }
            if (status == 4) {
                return State.INTERRUPTED.ordinal();
            }
        }
        return State.UNKNOWN.ordinal();
    }

    public String getEventName(ITimeEvent event) {
        if (event instanceof ControlFlowEvent) {
            int status = ((ControlFlowEvent)event).getStatus();
            if (status == 1) {
                return State.WAIT.toString();
            }
            if (status == 2) {
                return State.USERMODE.toString();
            }
            if (status == 3) {
                return State.SYSCALL.toString();
            }
            if (status == 4) {
                return State.INTERRUPTED.toString();
            }
        }
        return State.UNKNOWN.toString();
    }

    public Map<String, String> getEventHoverToolTipInfo(ITimeEvent event) {
        LinkedHashMap<String, String> retMap = new LinkedHashMap<String, String>();
        if (event instanceof ControlFlowEvent) {
            ControlFlowEntry entry = (ControlFlowEntry)event.getEntry();
            IStateSystemQuerier ssq = entry.getTrace().getStateSystem();
            int tid = entry.getThreadId();
            try {
                int cpusQuark = ssq.getQuarkAbsolute(new String[]{"CPUs"});
                List cpuQuarks = ssq.getSubAttributes(cpusQuark, false);
                for (Integer cpuQuark : cpuQuarks) {
                    ITmfStateValue state;
                    int currentThreadId;
                    int currentThreadQuark = ssq.getQuarkRelative(cpuQuark.intValue(), new String[]{"Current_thread"});
                    ITmfStateInterval interval = ssq.querySingleState(event.getTime(), currentThreadQuark);
                    if (interval.getStateValue().isNull() || tid != (currentThreadId = (state = interval.getStateValue()).unboxInt())) continue;
                    retMap.put(Messages.ControlFlowView_attributeCpuName, ssq.getAttributeName(cpuQuark.intValue()));
                    break;
                }
            }
            catch (AttributeNotFoundException e) {
                e.printStackTrace();
            }
            catch (TimeRangeException e) {
                e.printStackTrace();
            }
            catch (StateValueTypeException e) {
                e.printStackTrace();
            }
            int status = ((ControlFlowEvent)event).getStatus();
            if (status == 3) {
                try {
                    int syscallQuark = ssq.getQuarkRelative(entry.getThreadQuark(), new String[]{"System_call"});
                    ITmfStateInterval value = ssq.querySingleState(event.getTime(), syscallQuark);
                    if (!value.getStateValue().isNull()) {
                        ITmfStateValue state = value.getStateValue();
                        retMap.put(Messages.ControlFlowView_attributeSyscallName, state.toString());
                    }
                }
                catch (AttributeNotFoundException e) {
                    e.printStackTrace();
                }
                catch (TimeRangeException e) {
                    e.printStackTrace();
                }
            }
        }
        return retMap;
    }

    private static enum State {
        UNKNOWN(new RGB(100, 100, 100)),
        WAIT(new RGB(200, 200, 0)),
        USERMODE(new RGB(0, 200, 0)),
        SYSCALL(new RGB(0, 0, 200)),
        INTERRUPTED(new RGB(200, 100, 100));

        public final RGB rgb;

        private State(RGB rgb) {
            this.rgb = rgb;
        }
    }
}

