#########################
#########################
##                     ##
## Implementado por:   ##
## Jorge-Enrique Vidal ##
## EPFL/UPC            ##
## 2003-2004           ##
##                     ##
#########################
#########################

##############################################################################
# Este fichero contiene diferentes proceduras permitiendo crear las ventanas #
# segundarias y otras proceduras necesarias al buen funcinamiento de estas   #
# ventanas o que deban ejecutar.                                             #
##############################################################################



#
# Procedura de creacin de la ventana Breakpoints.
#
proc breakpwin {} {
    global BpInstrEn BpInstrDa Instr
    

    # Si la ventana ya existe, se destruye
    if {[winfo exists .main_window.bp]} {
	destroy .main_window.bp
    }

    # Creacin de la ventana
    toplevel .main_window.bp
    wm geometry .main_window.bp 335x430+400+100
    wm title .main_window.bp {Breakpoints}
    
    # Creacin de la frame que contendr los diferentes elementos
    frame .main_window.bp.f
    pack configure .main_window.bp.f -expand 1 -fill both
    

    # Separacin para el breakpoint de la instruccin
    label .main_window.bp.f.sep1 -text "Instruction breakpoint" \
	-bg grey80  -relief raise -justify center -padx 3.2c
    pack .main_window.bp.f.sep1 -side top -fill both -pady 0.2c

    
    # Creacin de la linea de seleccin del breakpoint de la instruccin
    frame .main_window.bp.f.instr 
    checkbutton .main_window.bp.f.instr.ck -text "If instruction is:" \
	-variable BpInstrEn
    label .main_window.bp.f.instr.l -text "$BpInstrDa \t\t"
    
    # Creacin del menu
    menubutton .main_window.bp.f.instr.mb -text "Change To" -relief \
	raised -menu .main_window.bp.f.instr.mb.menu
    menu .main_window.bp.f.instr.mb.menu -tearoff 0
    
    # Va a buscar todas las instrucciones posibles en el Array "Instr" y
    # las aade al menu. Cuando se selecciona una instruccin, se actualiza
    # la visualizacin.
    for {set x 1} {$x < 65} {incr x} {
	.main_window.bp.f.instr.mb.menu add radiobutton -label \
	    $Instr($x,fonc) -variable BpInstrDa -value $Instr($x,fonc) \
	    -command {.main_window.bp.f.instr.l configure \
			  -text "$BpInstrDa \t\t"}
    }
    
    pack configure .main_window.bp.f.instr.ck .main_window.bp.f.instr.l \
	.main_window.bp.f.instr.mb -side left -anchor w -in \
	.main_window.bp.f.instr
    pack configure .main_window.bp.f.instr -side top
    
    
    # Separacin para los diferentes breakpoints de la RAM
    label .main_window.bp.f.sep2 -text "RAM" -bg grey80  -relief raise \
	-justify center -padx 4c
    pack .main_window.bp.f.sep2 -side top -fill both -pady 0.2c
     

    # Creacin de los breakpoints para el Write de la RAM con direccin
    # adresse, el Write de la RAM con valor, el Read de la RAM con direccin
    # y el Read de la RAM con valeur gracias a la procedura genrica:
    # frameBpTxtVar
    frameBpTxtVar ramw_ad BpRamWriteAddrEn BpRamWriteAddr 4 \
	"If RAM is written at this adress:" "(Integer)"
    
    frameBpTxtVar ramw_da BpRamWriteDaEn BpRamWriteDa 8 \
	"If RAM is written with this data:" "(Hexadecimal)"
    
    frameBpTxtVar ramr_ad BpRamReadAddrEn BpRamReadAddr 4 \
	"If RAM is readed at this adress:" "(Integer)"
    
    frameBpTxtVar ramr_da BpRamReadDaEn BpRamReadDa 8 \
	"If RAM is readed with this data:" "(Hexadecimal)"
    
    
    # Separacin para los diferentes breakpoints del banco de registros
    label .main_window.bp.f.sep3 -text "Register File" -bg grey80 \
	-relief raise -justify center -padx 3.5c
    pack .main_window.bp.f.sep3 -side top -fill both -pady 0.2c 
    

    # Creacin de los breakpoints para el Write del Register File con
    # direccin, el Write del Register File con valor, el Read 1 del Register
    # File con direccin, el Read 1 del Register File con valor, el Read 1 del
    # Register File con direccin y el Read 1 del Register File con valor
    frameBpTxtVar regw_ad BpRegWriteAddrEn BpRegWriteAddr 2 \
	"If Register File is written at this adress:" "(Integer)"
    
    frameBpTxtVar regw_da BpRegWriteDaEn BpRegWriteDa 8 \
	"If Register File is written with this data:" "(Hexadecimal)"
    
    frameBpTxtVar regr1_ad BpRegRead1AddrEn BpRegRead1Addr 2 \
	"If Register File read 1 reads at this adress:" "(Integer)"
    
    frameBpTxtVar regr1_da BpRegRead1DaEn BpRegRead1Da 8 \
	"If Register File read 1 reads this data:" "(Hexadecimal)"
    
    frameBpTxtVar regr2_ad BpRegRead2AddrEn BpRegRead2Addr 2 \
	"If Register File read 2 reads at this adress:" "(Integer)"
    
    frameBpTxtVar regr2_da BpRegRead2DaEn BpRegRead2Da 8 \
	"If Register File read 2 reads this data:" "(Hexadecimal)"
    

    # Creacin del botn OK
    button .main_window.bp.f.b -text "OK" -command { destroy .main_window.bp }
    pack configure .main_window.bp.f.b -side bottom -pady 0.3c   
}


#
# Procedura genrica que sirve para crear la visualizacin y la activacin
# de los breakpoints. Sus parametros son:
#
# Obj: permite dar un nombre nico a cada linea
# VarCk: transmite el nombre del boleano que indica la activacin del
#        breakpoint
# VarEn: transmite el nombre de la variable que contiene el valor introducido
# Width: da la anchura del objeto de introduccin de texto
# TxtCk: el texto que tiene que aparecer en la linea creada
# TxtL: el texto del dormato de la variable de entrada
#
proc frameBpTxtVar { Obj VarCk VarEn Width TxtCk TxtL} {
    global $VarCk $VarEn
    
    frame .main_window.bp.f.$Obj
    checkbutton .main_window.bp.f.$Obj.ck -text $TxtCk -variable $VarCk
    entry .main_window.bp.f.$Obj.te -justify right -width $Width \
	-textvariable $VarEn
    label .main_window.bp.f.$Obj.l -text $TxtL
    
    pack configure .main_window.bp.f.$Obj.ck .main_window.bp.f.$Obj.te \
	.main_window.bp.f.$Obj.l -anchor w -side left -in \
	.main_window.bp.f.$Obj
    pack configure .main_window.bp.f.$Obj -side top    
}


#
# Procedura que crea la ventana de configuracin para la visualizacin de
# los diferentes valores, arrays y lineas de la Ram.
#
proc textconf {} {
    global Viewbr Viewram Viewrom Viewdata BeginRam VariationRam
    global tempbr tempram temprom tempdata tempBeginRam tempVariationRam
    
    # Variables que permiten visualizar los cambios efectuados antes de
    # que se apliquen
    set tempbr $Viewbr
    set tempram $Viewram
    set tempBeginRam $BeginRam
    set tempVariationRam $VariationRam
    set temprom $Viewrom
    set tempdata $Viewdata
    
    # Destruccin de la ventana si ya existe
    if {[winfo exists .main_window.tc]} {
	destroy .main_window.tc
    }
    
    # Creacin de la ventana
    toplevel .main_window.tc
    wm geometry .main_window.tc 270x270+430+130
    wm title .main_window.tc {View Options}
    
    # Creacin de la frame que contendr los diferentes elementos
    frame .main_window.tc.f
    pack configure .main_window.tc.f -expand 1 -fill both


    # Creacin de la visualizacin y del menu de la Rom
    frame .main_window.tc.f.rom
    label .main_window.tc.f.rom.l -text "Rom View: "
    label .main_window.tc.f.rom.v -text "$temprom \t\t"

    # Creacin del menu
    menubutton .main_window.tc.f.rom.mb -text "Change To" -relief raised \
	-menu .main_window.tc.f.rom.mb.menu
    menu .main_window.tc.f.rom.mb.menu -tearoff 0
    .main_window.tc.f.rom.mb.menu add command -label Binary \
	-command {set temprom Binary; .main_window.tc.f.rom.v configure \
		      -text "$temprom \t\t"}
    .main_window.tc.f.rom.mb.menu add command -label Octal \
	-command {set temprom Octal; .main_window.tc.f.rom.v configure \
		      -text "$temprom \t\t"}
    .main_window.tc.f.rom.mb.menu add command -label Hexadecimal \
	-command {set temprom Hexadecimal; .main_window.tc.f.rom.v configure \
		      -text "$temprom \t\t"}
    .main_window.tc.f.rom.mb.menu add command -label Decimal \
	-command {set temprom Decimal; .main_window.tc.f.rom.v configure \
		      -text "$temprom \t\t"}

    # Visualizacin del conjunto
    pack .main_window.tc.f.rom.l .main_window.tc.f.rom.v \
	.main_window.tc.f.rom.mb -side left -anchor w -in .main_window.tc.f.rom
    
    pack configure .main_window.tc.f.rom -side top -pady 0.2c

    
    # Creacin de la visualizacin y del menu del banco de registros
    frame .main_window.tc.f.br
    label .main_window.tc.f.br.l -text "Register File View: "
    label .main_window.tc.f.br.v -text "$tempbr \t\t"

    # Creacin del menu
    menubutton .main_window.tc.f.br.mb -text "Change To" -relief raised \
	-menu .main_window.tc.f.br.mb.menu
    menu .main_window.tc.f.br.mb.menu -tearoff 0
    .main_window.tc.f.br.mb.menu add command -label Binary -command \
	{set tempbr Binary; .main_window.tc.f.br.v configure -text \
	     "$tempbr \t\t"}
    .main_window.tc.f.br.mb.menu add command -label Octal -command \
	{set tempbr Octal; .main_window.tc.f.br.v configure -text \
	     "$tempbr \t\t"}
    .main_window.tc.f.br.mb.menu add command -label Hexadecimal -command \
	{set tempbr Hexadecimal; .main_window.tc.f.br.v configure -text \
	     "$tempbr \t\t"}
    .main_window.tc.f.br.mb.menu add command -label Decimal -command \
	{set tempbr Decimal; .main_window.tc.f.br.v configure -text \
	     "$tempbr \t\t"}
    
    # Visualizacin del conjunto
    pack .main_window.tc.f.br.l .main_window.tc.f.br.v \
	.main_window.tc.f.br.mb -side left -anchor w -in \
	.main_window.tc.f.br
    
    pack configure .main_window.tc.f.br -side top
    
    
    # Creacin de la visualizacin y del menu de la Ram
    frame .main_window.tc.f.ram
    label .main_window.tc.f.ram.l -text "Ram View: "
    label .main_window.tc.f.ram.v -text "$tempram \t\t"

    # Creacin del menu
    menubutton .main_window.tc.f.ram.mb -text "Change To" -relief raised \
	-menu .main_window.tc.f.ram.mb.menu
    menu .main_window.tc.f.ram.mb.menu -tearoff 0
    .main_window.tc.f.ram.mb.menu add command -label Binary -command \
	{set tempram Binary; .main_window.tc.f.ram.v configure -text \
	     "$tempram \t\t"}
    .main_window.tc.f.ram.mb.menu add command -label Octal -command \
	{set tempram Octal; .main_window.tc.f.ram.v configure -text \
	     "$tempram \t\t"}
    .main_window.tc.f.ram.mb.menu add command -label Hexadecimal -command \
	{set tempram Hexadecimal; .main_window.tc.f.ram.v configure -text \
	     "$tempram \t\t"}
    .main_window.tc.f.ram.mb.menu add command -label Decimal -command \
	{set tempram Decimal; .main_window.tc.f.ram.v configure -text \
	     "$tempram \t\t"}

    # Visualizacin del conjunto
    pack .main_window.tc.f.ram.l .main_window.tc.f.ram.v \
	.main_window.tc.f.ram.mb -side left -anchor w -in .main_window.tc.f.ram
    
    pack configure .main_window.tc.f.ram -side top -pady 0.2c

    
    # Creacin de la visualizacin y del menu de los valores situados en
    # la parte inferior de la ventana principal
    frame .main_window.tc.f.data
    label .main_window.tc.f.data.l -text "Data View: "
    label .main_window.tc.f.data.v -text "$tempdata \t\t"
    
    # Creacin del menu
    menubutton .main_window.tc.f.data.mb -text "Change To" -relief raised \
	-menu .main_window.tc.f.data.mb.menu
    menu .main_window.tc.f.data.mb.menu -tearoff 0
    .main_window.tc.f.data.mb.menu add command -label Binary -command \
	{set tempdata Binary; .main_window.tc.f.data.v configure -text \
	     "$tempdata \t\t"}
    .main_window.tc.f.data.mb.menu add command -label Octal -command \
	{set tempdata Octal; .main_window.tc.f.data.v configure -text \
	     "$tempdata \t\t"}
    .main_window.tc.f.data.mb.menu add command -label Hexadecimal -command \
	{set tempdata Hexadecimal; .main_window.tc.f.data.v configure -text \
	     "$tempdata \t\t"}
    .main_window.tc.f.data.mb.menu add command -label Decimal -command \
	{set tempdata Decimal; .main_window.tc.f.data.v configure -text \
	     "$tempdata \t\t"}
    
    # Visualizacin del conjunto
    pack .main_window.tc.f.data.l .main_window.tc.f.data.v \
	.main_window.tc.f.data.mb -side left -anchor w -in \
	.main_window.tc.f.data
    
    pack configure .main_window.tc.f.data -side top
    
    
    # Creacin de los botones para parametrar la visualizacin de la ram
    global BeginRam VariationRam
    frame .main_window.tc.f.dispram
    frame .main_window.tc.f.dispram.l1
    label .main_window.tc.f.dispram.l1.l -text "Display Ram from line: "
    entry .main_window.tc.f.dispram.l1.e -justify right -width 4 \
	-textvariable tempBeginRam
    frame .main_window.tc.f.dispram.l2
    label .main_window.tc.f.dispram.l2.l -text "Number of displayed lines: "
    entry .main_window.tc.f.dispram.l2.e -justify right -width 4 \
	-textvariable tempVariationRam

    # Visualizacin del conjunto
    pack .main_window.tc.f.dispram.l1.l .main_window.tc.f.dispram.l1.e \
	-side left -anchor w -in .main_window.tc.f.dispram.l1
    pack configure .main_window.tc.f.dispram.l1 -pady 0.1c -padx 1c
    
    pack .main_window.tc.f.dispram.l2.l .main_window.tc.f.dispram.l2.e \
	-side left -anchor w -in .main_window.tc.f.dispram.l2
    pack configure .main_window.tc.f.dispram.l2 -pady 0.1c -padx 0.5c
    
    pack .main_window.tc.f.dispram.l1 .main_window.tc.f.dispram.l2 \
	-side top -anchor w -in .main_window.tc.f.dispram

    pack configure .main_window.tc.f.dispram -side top -pady 0.5c
    
    
    
    # Creacin del botn OK y Cancel
    frame .main_window.tc.f.but
    button .main_window.tc.f.but.ok -text "OK" -command \
	{ apply_opt $tempbr $tempram $tempBeginRam $tempVariationRam \
	      $temprom $tempdata; destroy .main_window.tc }
    button .main_window.tc.f.but.can -text "Cancel" -command \
	{ destroy .main_window.tc }
    
    # Visualizacin de los botones
    pack .main_window.tc.f.but.ok -side left -anchor w -in \
	.main_window.tc.f.but -padx 0.4c -pady 0.2c
    pack .main_window.tc.f.but.can -side right -anchor w -in \
	.main_window.tc.f.but -padx 0.4c -pady 0.2c
    
    pack configure .main_window.tc.f.but -side bottom
}


#
# Esta procedura aplica las modificaciones efectuadas en la ventana de
# configuracin anterior. Slo las aplica si ha habido un cambio.
#
# Sus parametres son:
# br: el valor escogido en la ventana para el banco de registros
# ram: el valor escogido en la ventana para la RAM
# begram: el valor escogido en la ventana indicando la primera linea de la Ram
# varram: el valor escogido en la ventana indicando el numero de lineas
#         visualizadas en la Ram
# rom: el valor escogido en la ventana para la Rom
# data: el valor escogido en la ventana para los datos de la parte inferior
#       de la ventana principal
#
proc apply_opt { br ram begram varram rom data} {
    global Viewbr Viewram Viewrom Viewdata BeginRam VariationRam tempBeginRam tempVariationRam
    
    # Prueba si ha habido un cambio para el banco de registros. En ese caso,
    # se actualiza la visualizacin del banco de registros
    if {[string compare $Viewbr $br] != 0} {
	set Viewbr $br
	update_Reg $Viewbr
    }   
 
    # Prueba para la RAM
    if {[expr {[string compare $Viewram $ram] != 0}] || \
	    [expr {[string compare $BeginRam $begram] != 0}] || \
	    [expr {[string compare $VariationRam $varram] != 0}]} {
	set Viewram $ram

	# Gestin de un posible error o actualizacin
	set retval [catch {update_Ram $Viewram}]
	if {$retval == 1} {
	    set tempBeginRam $BeginRam
	    set tempVariationRam $VariationRam
	    error_win Ram
	} else {
	    set BeginRam $begram
	    set VariationRam $varram
	}	
    }

    # Prueba para la ROM
    if {[string compare $Viewrom $rom] != 0} {
	set Viewrom $rom
	update_Rom $Viewrom
    }

    # Prueba para los datos
    if {[string compare $Viewdata $data] != 0} {
	set Viewdata $data
	update_DataView
    }   
}


#
# Procedura que actualiza la visualizacin de las variables de la ROM,
# el parametro choice representa el nuevo formato de los valores
#
proc update_Rom { choice } {
    global RomArray NumLinesRom RomBp RomLine
    
    # Permisin de escritura en la ventana de la ROM
    .main_window.i.rom.data configure -state normal
    
    for {set x 0} {$x < $NumLinesRom} {incr x} {
	# Recuperacin de la linea a modificar
	set Line [.main_window.i.rom.data get [expr {$x+1}].0 \
		      [expr {$x+1}].end]
	# Sealizacin del principio y el final de la palabra que hay que
	# cambiar
	set sw [string wordstart $Line 9]
	set ew [string wordend $Line 9]

	# Calibracin en el caso que la linea este marcada con un punto
	# de parada al principio de la linea
	if {$RomBp($x) == 1 || $RomLine($x) == 1} {
	    incr sw 1
	    incr ew 1
	}
	# Escritura de la palabra segn su formato, recuperada en el
	# array: RomArray
	.main_window.i.rom.data delete [expr {$x+1}].$sw [expr {$x+1}].$ew
	.main_window.i.rom.data insert [expr {$x+1}].$sw $RomArray($x,$choice)
    }

    # Actualizacin del ttulo
    .main_window.i.romtitle configure -text "Rom Data ($choice View)"

    # Desactivatin del derecho de escritura
    .main_window.i.rom.data configure -state disabled
}


#
# Procedura que actualiza la visualizacin de las variables del banco de
# registros, el parametro choice representa el nuevo formato de los valores
#
proc update_Reg { choice } {
    global RegArray
    
    # Permisin de escritura en la ventana del banco de registros
    .main_window.i.regfile.data configure -state normal

    for {set x 0} {$x < 32} {incr x} {
	# Reescritura de la linea entera con la palabra recuperada segn su
	# formato en el array: RegArray
	set line [format "%02u" $x]
	.main_window.i.regfile.data delete [expr {$x + 1}].0 [expr {$x + 2}].0
	.main_window.i.regfile.data insert [expr {$x + 1}].0 "$line $RegArray($x,$choice)\n"
    }
    
    # Actualizacin del ttulo
    .main_window.i.regfiletitle configure -text "Regfile Data ($choice View)"

    # Desactivatin del derecho de escritura
    .main_window.i.regfile.data configure -state disabled    
}


#
# Procedura que actualiza la visualizacin de las variables de la Ram, el
# parametro choice representa el nuevo formato de los valores
#
proc update_Ram { choice } {
    global RamArray VariationRam BeginRam Ramsize 
    global tempBeginRam tempVariationRam NumLinesRam
    
    # Permisin de escritura en la ventana de la RAM
    .main_window.i.ram.data configure -state normal

    # Borra el contenido de la ventana
    for {set x 0} {$x < $VariationRam} {incr x} {
	.main_window.i.ram.data delete 1.0 2.0
    }
    
    # Reescritura de las lineas correspondientes a los nuevos valores
    for {set x $tempBeginRam} {$x < [expr {$tempVariationRam+$tempBeginRam}]} {incr x} {
	
	# Escritura de la linea "x" de la ram en la posicin que le corresponde
	# respecto a la nueva visualizacin
	set xVar [expr {$x-$tempBeginRam}]
	set line [format "%04u" $x]
	.main_window.i.ram.data insert [expr {$xVar + 1}].0 \
	    "$line $RamArray($x,$choice)\n"
    }

    # Desactivacin del derecho de escritura
    .main_window.i.ram.data configure -state disabled 

    # Actualizacin del ttulo
    .main_window.i.ramtitle configure -text "Ram Data ($choice View)"

    # Actualizacin de los antigos valores globales
    set NumLinesRam $tempVariationRam

    # Clculo del nuevo valor que permite identificar una linea seleccionada
    calcpercentram
}


#
# Procedura que actualiza diferentes valores en el caso de un cambio de
# formato, cuando un breakpoint ocurre o cuando se reinicializa la simulacin
#
proc update_DataView {} {  
    global now
    instr_update
    PC_update
    register_32 /micro_bloc/micro_bloc/microcontroller/stack_pointer/SP up.center.sp	
    mascara_update
    register_32 /micro_bloc/micro_bloc/microcontroller/ALUshifter/A up.left.sr1
    register_32 /micro_bloc/micro_bloc/microcontroller/ALUshifter/B up.left.sr2
    register_32 /micro_bloc/micro_bloc/microcontroller/ALUshifter/Result up.left.dr
    register_20 /micro_bloc/micro_bloc/sahbi_in_haddr up.center.ahbiinhaddr
    register_32 /micro_bloc/micro_bloc/sahbi_out_haddr up.center.ahbiouthaddr
    register_32 /micro_bloc/micro_bloc/sahb_out_data up.center.ahboutdata
    register_32 /micro_bloc/micro_bloc/sahb_in_data up.center.ahbindata
    .main_window.i.register.up.right.ahbinsel.v configure -text "[examine -value /micro_bloc/micro_bloc/sahbi_in_hsel]"
    .main_window.i.register.up.right.ahbinready.v configure -text "[examine -value /micro_bloc/micro_bloc/sahbi_in_hready]"
    .main_window.i.register.up.right.ahbinwrite.v configure -text "[examine -value /micro_bloc/micro_bloc/sahbi_in_hwrite]"
    .main_window.i.register.up.right.ahboutsel.v configure -text "[examine -value /micro_bloc/micro_bloc/sahbi_out_hsel]"
    .main_window.i.register.up.right.ahboutready.v configure -text "[examine -value /micro_bloc/micro_bloc/sahbi_out_hready]"
    .main_window.i.register.up.right.ahboutwrite.v configure -text "[examine -value /micro_bloc/micro_bloc/sahbi_out_hwrite]"
    .main_window.i.time configure -text "Runing Time : $now ns"
}


#
# Procedura genrica que permite abrir una ventana que informando que un
# breakpoint ha ocurrido. Esta ventana contiene informacin respecto al
# breakpoint. Esto en el caso de un breakpoint informando sobre un valor
# significativo
#
# Sus parmetros son:
# Obj: que permite saber que breakpoint ha ocurrido
# Value: el valor significativo
#
proc break_report_one_val { Obj Value} {
    global now
    
    # Si la ventana ya existe, se destruye
    if {[winfo exists .main_window.bpr]} {
	destroy .main_window.bpr
    }
    
    # Creacin de la ventana
    toplevel .main_window.bpr
    wm geometry .main_window.bpr 300x80+400+100
    wm title .main_window.bpr {Breakpoints Report}
    
    # Seleccin de la visualizacin segn el breakpoint ocurrido
    switch $Obj {
	PC {label .main_window.bpr.l -text "PC equals $Value" -padx 10 \
		-pady 10; label .main_window.bpr.l2 -text "At time:  $now ns" \
		   -padx 10 -pady 10}
	Instr {label .main_window.bpr.l -text "Instruction is $Value" \
		   -padx 10 -pady 10; label .main_window.bpr.l2 -text \
		   "At time:  $now ns" -padx 10 -pady 10}
    }  

    # Visualizacin y actualizacin de los dems valores
    pack .main_window.bpr.l .main_window.bpr.l2 -side top
    update_DataView
}


#
# Procedura identica a break_report_one_val, pero con un valor significativo
# ms
#
proc break_report_two_val { Obj Value1 Value2 } {
    global now

    # Si la ventana ya existe, se destruye
    if {[winfo exists .main_window.bpr]} {
	destroy .main_window.bpr
    }
    
    # Creacin de la ventana
    toplevel .main_window.bpr
    wm geometry .main_window.bpr 345x120+260+230
    wm title .main_window.bpr {Breakpoints Report}

    # Seleccin de la visualizacin segn el breakpoint ocurrido
    switch $Obj {
	Ramwa {label .main_window.bpr.l1 -text \
		   "Ram is written at the adress  $Value1" -padx 10 -pady 10; \
		   label .main_window.bpr.l2 -text "With the data  0x$Value2" \
		   -padx 10 -pady 10; label .main_window.bpr.l3 -text \
		   "At time:  $now ns" -padx 10 -pady 10}
	Ramwd {label .main_window.bpr.l1 -text \
		   "Ram is written with the data  0x$Value1" -padx 10 -pady 10; \
		   label .main_window.bpr.l2 -text "At the address  $Value2" \
		   -padx 10 -pady 10; label .main_window.bpr.l3 -text \
		   "At time:  $now ns" -padx 10 -pady 10}
	Ramra {label .main_window.bpr.l1 -text \
		   "Ram is readed at the adress  $Value1" -padx 10 -pady 10; \
		   label .main_window.bpr.l2 -text \
		   "The data readed is  0x$Value2" -padx 10 -pady 10; label \
		   .main_window.bpr.l3 -text "At time:  $now ns" -padx 10 -pady 10}
	Ramrd {label .main_window.bpr.l1 -text \
		   "Ram is readed with the data  0x$Value1" -padx 10 -pady 10; \
		   label .main_window.bpr.l2 -text "At the address  $Value2" \
		   -padx 10 -pady 10; label .main_window.bpr.l3 -text \
		   "At time:  $now ns" -padx 10 -pady 10}
	RegFwa {label .main_window.bpr.l1 -text \
		    "Register File is written at the address  $Value1" \
		    -padx 10 -pady 10; label .main_window.bpr.l2 -text \
		    "With the data  0x$Value2" -padx 10 -pady 10; label \
		    .main_window.bpr.l3 -text "At time:  $now ns" -padx 10 -pady 10}
	RegFwd {label .main_window.bpr.l1 -text \
		    "Register File is written with the data  0x$Value1" -padx 10 \
		    -pady 10; label .main_window.bpr.l2 -text \
		    "At the address  $Value2" -padx 10 -pady 10; label \
		    .main_window.bpr.l3 -text "At time:  $now ns" -padx 10 -pady 10}
	RegFr1ra {label .main_window.bpr.l1 -text \
		      "RegFile Read1 reads at the address  $Value1" -padx 10 \
		      -pady 10; label .main_window.bpr.l2 -text \
		      "The data readed is  0x$Value2" -padx 10 -pady 10; label \
		      .main_window.bpr.l3 -text "At time:  $now ns" -padx 10 \
		      -pady 10}
	RegFr1rd {label .main_window.bpr.l1 -text \
		      "RegFile Read1 reads the data  0x$Value1" \
		      -padx 10 -pady 10; label .main_window.bpr.l2 -text \
		      "At the address  $Value2" -padx 10 -pady 10; label \
		      .main_window.bpr.l3 -text "At time:  $now ns" -padx 10 \
		      -pady 10}
	RegFr2ra {label .main_window.bpr.l1 -text \
		      "RegFile Read2 reads at the address  $Value1" -padx 10 \
		      -pady 10; label .main_window.bpr.l2 -text \
		      "The data readed is  0x$Value2" -padx 10 -pady 10; label \
		      .main_window.bpr.l3 -text "At time:  $now ns" -padx 10 \
		      -pady 10}
	RegFr2rd {label .main_window.bpr.l1 -text \
		      "RegFile Read2 reads the data  0x$Value1" -padx 10 \
		      -pady 10; label .main_window.bpr.l2 -text \
		      "At the address  $Value2" -padx 10 -pady 10; label \
		      .main_window.bpr.l3 -text "At time:  $now ns" -padx 10 \
		      -pady 10}
    }

    # Visualizacin y actualizacin de los dems valores
    pack .main_window.bpr.l1 .main_window.bpr.l2 .main_window.bpr.l3 -side top
    update_DataView
}


#
# Procedura de gestin de diferentes errores posibles segn el objeto del
# parmetro
#
proc error_win { Obj } { 
    
    # Si la ventana ya existe, se destruye
    if {[winfo exists .main_window.error]} {
	destroy .main_window.error
    }
    
    # Creacin de la ventana
    toplevel .main_window.error
    wm title .main_window.error {Error}
    wm geometry .main_window.error +300+280
    
    # Escritura del mensage de error y gestin permitiendo continuar el
    # programa
    switch $Obj {
	Ram {global NumLinesRam Viewram; label .main_window.error.l -text \
		 "THE VALUES TO DISPLAY THE RAM ARE NOT CORRECT \n PLEASE \
CONTROL THAT THE LINES YOU WANT TO DISPLAY ARE BETWEEN 0 AND\
[expr {$NumLinesRam-1}]!" -padx 10 -fg red -pady 10; pack .main_window.error.l\
 -side top; update_Ram $Viewram}
	IntroRam {label .main_window.error.l -text "THE VALUE TO INSERT IN \
    THE RAM IS NOT CORRECT \n PLEASE TRY AGAIN WITH A CORRECT VALUE" -padx 10\
 -fg red -pady 10; pack .main_window.error.l -side top }
	IntroReg {label .main_window.error.l -text "THE VALUE TO INSERT IN \
    THE REGISTER FILE IS NOT CORRECT \n PLEASE TRY AGAIN WITH A CORRECT VALUE" -padx 10\
 -fg red -pady 10; pack .main_window.error.l -side top }
    }
}







