#########################
#########################
##                     ##
## Implementado por:   ##
## Jorge-Enrique Vidal ##
## EPFL/UPC            ##
## 2003-2004           ##
##                     ##
#########################
#########################

#############################################################################
# Este fichero contiene las diferentes proceduras que tienen que realizarse #
# tras un "clic" del botn derecho del ratn en una de las zonas de texto   #
# de la ventana principal. Tambin contiene las proceduras que permiten la  #
# identificacin de la linea seleccionada.                                  #
#############################################################################


#
# Procedura que permite la insercin de breakpoints en la ROM gracias la
# botn derecho del ratn. El parmetro da la posicin vertical del ratn 
# al momento de la seleccin.
#
proc insertBp { pos } {
    global RomBp NumLinesRom RomLine

    # Identificacin de la linea seleccionada
    set line [calc_line $pos $NumLinesRom rom]
    
    # Prueba si no hay indicador de linea aparente
    if { $RomLine($line) == 0 } {
	# Quita o aade un breakpoint al principio de la linea en funcin de su
	# estado actual.
	if { $RomBp($line) == 0 } {
	    set ImageName [pwd]/Interface/Images/virt_du.gif
	    set pict [image create photo Bp -file $ImageName]
	    # Derecho de escritura, insercin de la imagen, supresin del derecho
	    # de escritura e insercin del breakpoint en el array RomBp
	    .main_window.i.rom.data configure -state normal
	    .main_window.i.rom.data delete [expr {$line+1}].0 [expr {$line+1}].2
	    .main_window.i.rom.data image create [expr {$line+1}].0 -image $pict
	    .main_window.i.rom.data configure -state disabled
	    set RomBp($line) 1
	} elseif { $RomBp($line) == 1 } {
	    # Derecho de escritura, supresin de la imagen, supresin del derecho
	    # de escritura y supresin del breakpoint en el array RomBp
	    .main_window.i.rom.data configure -state normal
	    .main_window.i.rom.data delete [expr {$line+1}].0
	    .main_window.i.rom.data insert [expr {$line+1}].0 "  "
	    .main_window.i.rom.data configure -state disabled
	    set RomBp($line) 0
	} else {
	    puts "Error in RomBp($line)"
	}   
	# Si hay indicador de linea, solo se modifica el array y no
	# se aade el punto rojo
    } else {
	if { $RomBp($line) == 0 } {
	    set RomBp($line) 1
	} elseif { $RomBp($line) == 1 } {	    
	    set RomBp($line) 0
	} else {
	    puts "Error in RomBp($line)"
	}
    }
}


# 
# Procedura genrica que recive como parametros la posicin vertical del
# ratn el momento de la seleccin de una linea y dos identificadores de la
# ventana en la que ha ocurrido. Despus va a llamar otra procedura que
# transforme la posicin del ratn el la linea deseada y llamara la ventana
# de insercin de variables.
# 
proc insertValue { pos Obj nameobj} {
    global NumLines$Obj line_insert
    set line_insert [calc_line $pos [set NumLines$Obj] $nameobj]
    set data [insert_val_win $Obj]
}


#
# Procedura que crea la ventana de insercin de una variable. Propone escoger
# el formato de la variable a introducir. Su parmetro es un identificador de
# la ventana seleccionada.
#
proc insert_val_win { Obj } {
    global tempins Viewins InsVar line_insert
    
    # Si la ventana ya existe, se destruye
    if {[winfo exists .main_window.insval]} {
	destroy .main_window.insval
    }
    
    # Creacin de la ventana
    toplevel .main_window.insval
    wm title .main_window.insval "Insert $Obj Data in line $line_insert"

    # Opciones de visualizacin que varian segn la ventana seleccionada
    switch $Obj {
	Regfile {wm geometry .main_window.insval +300+100}
	Ram {wm geometry .main_window.insval +300+370}
    }
   
    frame .main_window.insval.f
    pack configure .main_window.insval.f -expand 1 -fill both

    set tempins $Viewins
    set InsVar 0


    # Creacin de la linea de seleccin del formato
    frame .main_window.insval.f.data
    label .main_window.insval.f.data.l -text "Format entry data: "
    label .main_window.insval.f.data.v -text "$tempins \t\t"

    # Creacin del menu
    menubutton .main_window.insval.f.data.mb -text "Change To" -relief raised \
	-menu .main_window.insval.f.data.mb.menu
    menu .main_window.insval.f.data.mb.menu -tearoff 0
    .main_window.insval.f.data.mb.menu add command -label Binary -command \
	{set tempins Binary; .main_window.insval.f.data.v configure -text \
	     "$tempins \t\t"; .main_window.insval.f.te configure -width 32}
    .main_window.insval.f.data.mb.menu add command -label Octal -command \
	{set tempins Octal; .main_window.insval.f.data.v configure -text \
	     "$tempins \t\t"; .main_window.insval.f.te configure -width 11}
    .main_window.insval.f.data.mb.menu add command -label Hexadecimal \
	-command {set tempins Hexadecimal; .main_window.insval.f.data.v \
		      configure -text "$tempins \t\t"; \
		      .main_window.insval.f.te configure -width 8}
    .main_window.insval.f.data.mb.menu add command -label Decimal \
	-command {set tempins Decimal; .main_window.insval.f.data.v \
		      configure -text "$tempins \t\t"; \
		      .main_window.insval.f.te configure -width 10}
    
    # Agrupacin de los elementos y visualizacin
    pack .main_window.insval.f.data.l .main_window.insval.f.data.v \
	.main_window.insval.f.data.mb -side left -anchor w -in \
	.main_window.insval.f.data   
    pack configure .main_window.insval.f.data -side top -pady 0.3c
    
    entry .main_window.insval.f.te -justify right -width 10 \
	-textvariable InsVar
    pack configure .main_window.insval.f.te -side top -pady 0.2 -pady 0.4c

    
    # Creacin del botn OK
    frame .main_window.insval.f.but
    button .main_window.insval.f.but.ok -text "OK" 

    # Definicin de la accin que hay que realizar segn la ventana
    # seleccionada. Tratamiento del error de insercin posible, y
    # escritura en la memoria adecuada.
    switch $Obj {
	Regfile {.main_window.insval.f.but.ok configure -command \
		     {set retval [catch {set value [transfval $tempins $InsVar Regfile]}];\
			  if {$retval == 1} {error_win IntroReg} else {insert_val_reg $line_insert $value};\
			  destroy .main_window.insval }}
	Ram {.main_window.insval.f.but.ok configure -command \
		 {set retval [catch {set value [transfval $tempins $InsVar Ram]}]; \
		      if {$retval == 1} {error_win IntroRam} else {insert_val_ram $line_insert $value};\
		      destroy .main_window.insval }}
    }

    # Creacin del botn Cancel
    button .main_window.insval.f.but.can -text "Cancel" -command \
	{ destroy .main_window.insval }
    
    # Agrupacin y visualizacin de los dos botones
    pack .main_window.insval.f.but.ok -side left -anchor w -in \
	.main_window.insval.f.but -padx 0.4c -pady 0.2c
    pack .main_window.insval.f.but.can -side right -anchor w -in \
	.main_window.insval.f.but -padx 0.4c -pady 0.2c
    
    pack configure .main_window.insval.f.but -side bottom -padx 2c   
}


#
# Procedura que permite calcular el porcentaje de una linea de texto respecto
# a toda la barra de desplazamiento de la visualizacin de la Ram. Se emplea
# cuando se cambia una opcin en la configuracin de la visualizacin de la
# Ram.
#
proc calcpercentram { } {
    global PercentLineram

    # Se mueve el texto de una linea hacia abajo y se guarda el porcentaje
    # de desplazamiento efectuado respecto a toda la barra de desplazamiento.
    # Se vuelve a poner la barra en su sitio.
    .main_window.i.ram.data yview scroll 1 units
    set PercentLineram [lindex [.main_window.i.ram.data yview] 0]
    .main_window.i.ram.data yview scroll -1 units
}


#
# Procedura que permite calcular la linea real seleccionada (indicada por el
# numero a la izquierda en una linea de texto) partiendo de la posicin
# vertical del ratn y de la posicin de la barra de desplazamiento.
#
# Sus parmetros son:
# pos: posicin vertical del ratn (en pixel)
# verticallines: numero de lineas visibles por ventana
# type: identifica la ventana seleccionada
#
proc calc_line { pos verticallines type } {
    global pix_per_line start_disp_$type PercentLine$type LinesWin$type BeginRam
    
    # Recuperacin de la posicin de la barra de desplazamiento
    set percent_view [.main_window.i.$type.data yview]

    # Clculo de la linea respecto a las lineas visibles
    set line_in_win [expr {round((($pos-[set start_disp_$type])/$pix_per_line)+0.5)-1}]
    
    # Compensacin en caso de error
    if {$line_in_win < 0} {
   	set line_in_win 0
    } elseif {$line_in_win > [expr {[set LinesWin$type]-1}]} {
   	set line_in_win [expr {[set LinesWin$type]-1}]
    }
    
    # Gestin del caso de las ventanas que proponen menos lineas visibles de
    # lo que podrian.
    if {[set PercentLine$type] == 0} {
	set Line $line_in_win
    } else {
	# Clculo del numero de la primera linea que aparece arriba de las
	# ventanas de texto gracias a la posicin de la barra de
	# desplazamiento. A esto se le aade el nmero de la linea respecto
	# a las lineas visibles
	set Line [expr {round([lindex $percent_view 0]/[set PercentLine$type])+$line_in_win}]
    }
    
    # Control de no pasarse de la linea maxima tolerada.
    if { $Line > [expr {$verticallines-1}] } {
  	set Line [expr {$verticallines-1}]
    }
    
    # Clculo de la linea en el caso que la visualizacin de la Ram haya
    # sido modificada
    if {[string compare $type ram] == 0} {
	set Line [expr {$Line+$BeginRam}]
    }

    return $Line   
}


# 
# Procedura que transforma un valor de insercin segn su formato, en un
# valor binario de 32 bits. Sus parmetros son el formato del valor insertado,
# su valor y la ventana que lo enva. 
# 
proc transfval { type value Obj} {
    
    # Transformacin segn el formato
    switch $type {
	Hexadecimal {binary scan [binary format I1 0x$value] B* binval}
	Octal {binary scan [binary format I1 00$value] B* binval}
	Decimal {binary scan [binary format I1 $value] B* binval}
	Binary {binary scan [binary format B32 [format "%032s" $value]] B* binval}
    }
   
    return $binval
}


#
# Esta funcin permite escribir en la RAM. Los parametros de entrada son
# la linea y el valor que se quiere aadir a esa linea. 
# No permite escribir si el microprocesador va a leer o escribir a la misma
# direccin que la que llama esta funcin. La escritura se efectuara cuando
# el microprocesador ya no quiera efectuar nada en esa direccin.
#
proc insert_val_ram { line val } {
    global insertData line_in addresse_in DataInRam

    set insertData $val
    set line_in $line
    binary scan [binary format I1 $line] B* line_bin
    set addresse_in [string range $line_bin 24 31]
    
    # Prueba de escritura del microprocesador a la misma direccin
    if {[expr {[string compare [examine -value /ram_bloc/bloc_memoria/addr] $addresse_in] == 0}] && [expr {[string compare [examine -value /ram_bloc/bloc_memoria/we] 1] == 0}]} {

	# Espera cambio del we del procesador para volver a intentar efectuar
	# la escritura.
	when -label we {/ram_bloc/bloc_memoria/we = '0'} {
	    nowhen addr
	    nowhen we
	    insert_val_ram $line_in $insertData
	}
		
	# Espera cambio de la direccin de la escritura del procesador para
	# volver a intentar efectuar la escritura.
	when -label addr /ram_bloc/bloc_memoria/addr {
	    nowhen we
	    nowhen addr
	    insert_val_ram $line_in $insertData
	}

	# Prueba de lectura del microprocesador a la misma direccin
    } elseif {[expr {[string compare [examine -value /ram_bloc/bloc_memoria/addr] $addresse_in] == 0}] && [expr {[string compare [examine -value /ram_bloc/oe] 1] == 0}]} {
	
	# Espera cambio del oe del procesador para volver a intentar efectuar
	# la escritura.
	when -label oe {/ram_bloc/oe = '0'} {
	    nowhen addr
	    nowhen oe
	    insert_val_ram $line_in $insertData
	}
	
	# Espera cambio de la direccin de la lectura del procesador para
	# volver a intentar efectuar la escritura.
	when -label addr /ram_bloc/bloc_memoria/addr {
	    nowhen oe
	    nowhen addr
	    insert_val_ram $line_in $insertData
	}

	# Preparacin para la escritura, controlando que el microprocesador
	# no cambie de direccin, de we o de oe.
    } else {
	force /ram_bloc/bloc_memoria/my_we 1 0
	force /ram_bloc/bloc_memoria/my_addr $addresse_in 0
	force /ram_bloc/bloc_memoria/my_data $val 0
	
	# En el caso de un cambio de direccin, prueba si las direcciones
	# coinciden. En este caso, se anula la escritura y se vuelve a lanzar
	# la funcin que esperara a que las seales sean correctas antes de
	# intentar escribir otra vez.
	when -label add /ram_bloc/bloc_memoria/addr {
	    if {[string compare [examine -value /ram_bloc/bloc_memoria/addr] $addresse_in] == 0} {
		force /ram_bloc/bloc_memoria/my_we 0 0
		nowhen add
		nowhen we
		nowhen oe
		nowhen clk

		insert_val_ram $line_in $insertData
	    }	    
	}
	
	# Comportamiento similar a la pruba que precede pero en el caso de un
	# cambio de we.
	when -label we {/ram_bloc/bloc_memoria/we = '1'} {
	    if {[string compare [examine -value /ram_bloc/bloc_memoria/addr] $addresse_in] == 0} {
		force /ram_bloc/bloc_memoria/my_we 0 0
		nowhen add
		nowhen we
		nowhen oe
		nowhen clk

		insert_val_ram $line_in $insertData
	    }	    
	}
	
	# Comportamiento similar a la pruba que precede pero en el caso de un
	# cambio de oe.
	when -label oe {/ram_bloc/oe = '1'} {
	    if {[string compare [examine -value /ram_bloc/bloc_memoria/addr] $addresse_in] == 0} {
		force /ram_bloc/bloc_memoria/my_we 0 0
		nowhen add
		nowhen we
		nowhen oe
		nowhen clk

		insert_val_ram $line_in $insertData
	    }	    
	}
	
	# Espera el cambio de flanco del reloj para escribir y desactivar la 
	# seal que permite la escritura y actualiza la visualizacin de la RAM.
	when -label clk {/ram_bloc/bloc_memoria/clk = '0'} {
	    force /ram_bloc/bloc_memoria/my_we 0 0
	    set DataInRam $insertData
	    set temp_line 000000$addresse_in
	    binary scan [binary format B16 $temp_line] S* addr_num
	    write_line_Ram $addr_num 
	    nowhen add
	    nowhen we
	    nowhen oe
	    nowhen clk
	}
    }   
}


#
# Esta funcin permite escribir en el banco de registros. Los parametros de
# entrada son la linea y el valor que se quiere aadir a esa linea. 
# No permite escribir si el microprocesador va a escribir a la misma
# direccin que la que llama esta funcin. La escritura se efectuara cuando
# el microprocesador ya no quiera escribir en esa direccin.
#
proc insert_val_reg { line val } {
    global insertDataReg line_in_reg addresse_in_reg DataInReg

    set insertDataReg $val
    set line_in_reg $line
    binary scan [binary format I1 $line] B* line_bin
    set addresse_in_reg [string range $line_bin 27 31]
    
    #prueba de escritura del microprocesador a la misma direccin
    if {[expr {[string compare [examine -value /micro_bloc/regfile_bloc/waddr] $addresse_in_reg] == 0}] && [expr {[string compare [examine -value /micro_bloc/regfile_bloc/write] 1] == 0}]} {
	
	
	# Espera cambio de la direccin del procesador para volver a intentar
	# efectuar la escritura.
	when -label addrReg /micro_bloc/regfile_bloc/waddr {
	    nowhen wre
	    nowhen addrReg
	    insert_val_reg $line_in_reg $insertDataReg
	}
	
	# Espera cambio del write del procesador para volver a intentar efectuar
	# la escritura.
	when -label wre {/micro_bloc/regfile_bloc/write = '0'} {
	    nowhen addrReg
	    nowhen wre
	    insert_val_reg $line_in_reg $insertDataReg
	}
	
	# Preparacin para la escritura, controlando que el microprocesador
	# no cambie de write enable o de direccin de escritura.
    } else {
	force /micro_bloc/regfile_bloc/u0/my_we 1 0
	force /micro_bloc/regfile_bloc/u1/my_we 1 0
	force /micro_bloc/regfile_bloc/u0/my_addr $addresse_in_reg 0
	force /micro_bloc/regfile_bloc/u1/my_addr $addresse_in_reg 0
	force /micro_bloc/regfile_bloc/u0/my_data $val 0
	force /micro_bloc/regfile_bloc/u1/my_data $val 0
	
	# En el caso de un cambio de direccin, prueba si las direcciones
	# coinciden. En este caso, se anula la escritura y se vuelve a lanzar
	# la funcin que esperara a que las seales sean correctas antes de
	# intentar escribir otra vez.	
	when -label addReg /micro_bloc/regfile_bloc/waddr {
	    if {[string compare [examine -value /micro_bloc/regfile_bloc/waddr] $addresse_in_reg] == 0} {
		force /micro_bloc/regfile_bloc/u0/my_we 0 0
		force /micro_bloc/regfile_bloc/u1/my_we 0 0
		nowhen wrReg
		nowhen clkReg
		nowhen addReg
		
		insert_val_reg $line_in_reg $insertDataReg		
	    }
	}

	# Comportamiento similar a la prueba que precede pero en el caso de un
	# cambio de write enable.
	when -label wrReg {/micro_bloc/regfile_bloc/write = '1'} {
	    if {[string compare [examine -value /micro_bloc/regfile_bloc/waddr] $addresse_in_reg] == 0} {
		force /micro_bloc/regfile_bloc/u0/my_we 0 0
		force /micro_bloc/regfile_bloc/u1/my_we 0 0
		nowhen addReg
		nowhen clkReg
		nowhen wrReg
		
		insert_val_reg $line_in_reg $insertDataReg
	    }	    
	}
	
	# Espera el cambio de flanco del reloj para escribir y desactivar las 
	# seales que permiten la escritura y actualiza la visualizacin del
	# banco de registros.
	when -label clkReg {/micro_bloc/regfile_bloc/clk = '0'} {
	    force /micro_bloc/regfile_bloc/u0/my_we 0 0
	    force /micro_bloc/regfile_bloc/u1/my_we 0 0
	    set DataInReg $insertDataReg
	    set temp_line_reg 00000000000$addresse_in_reg
	    binary scan [binary format B16 $temp_line_reg] S* addr_num
	    write_line_BReg $addr_num

	    nowhen addReg
	    nowhen wrReg
	    nowhen clkReg	    
	}	
    }    
}


 
