#########################
#########################
##                     ##
## Implementado por:   ##
## Jorge-Enrique Vidal ##
## EPFL/UPC            ##
## 2003-2004           ##
##                     ##
#########################
#########################

##############################################################################
# Este fichero contiene la procedura de interpretacin de las instruciones   #
# del microprocesador y la creacin del array conteniendo las diferentes     #
# formas que pueden tener esas instrucciones.                                #
##############################################################################



#
# Procedura que interpreta el codigo de las instruciones y que retorna el
# nombre, el detalle y el codigo ensamblador de la instruccin correspondiendo
# a la documentacin.
# Su parametro de entrada es el codigo binario de la instruccion
#
proc interpreter { instr } {
    global Instr
    
    set match 0
    
    # Recuperacin del "opcode" de la instrucin
    set opcode [string range $instr 0 5]

    # Recorre el array de las instrucciones para encontrar las diferentes
    # formas de escritura de la instruccin. 
    if {$opcode == "UUUUUU"} {
	set cat N
	set match 1
	# Caso de una instrucin con bits "modifier"
    } elseif {[string compare $opcode 111011] == 0} {
	set modifier [string range $instr 11 14]
	for {set x 29} {$x < 34} {incr x} {
	    if {[string compare $modifier [set Instr($x,modif)]] == 0} {
		set cat [set Instr($x,classe)]
		set txt [set Instr($x,descr)]	
		set ins [set Instr($x,fonc)]
		set mne [set Instr($x,mnemonic)]
		set match 1
	    }
	}
	# Caso de la instruccin "SetMask" que por cuestiones alfabticas est
	# separada de las dems instrucciones con "modifier"
	if {[string compare $match 0] == 0} {
	    if {[string compare $modifier [set Instr(51,modif)]] == 0} {
		set cat [set Instr(51,classe)]
		set txt [set Instr(51,descr)]	
		set ins [set Instr(51,fonc)]
		set mne [set Instr(51,mnemonic)]	
		set match 1
	    }
	}
	# Busquedad en los dems casos
    } else {
	for {set x 1} {$x < 64} {incr x} {
	    if {[string compare $opcode [set Instr($x,bin)]] == 0} {	       
		set cat [set Instr($x,classe)]
		set txt [set Instr($x,descr)]
		set ins [set Instr($x,fonc)]
		set mne [set Instr($x,mnemonic)]
		set match 1
	    }
	} 
    }
    # Si no se ha encontrado correspondencia, se considera la instruccin
    # desconocida.
    if {[string compare $match 0] == 0} {
	set cat U
    }

    # Preparacin de las variables en vista de la substitucin segn el
    # formato de la instruccin. El formato es tambin es recuperado en el
    # array Instr. 
    # La substitucin se efectuar cambiando el nombre genrico, por ejemplo
    # DR, por la direccin del registro, por ejemplo R2.
    switch $cat {
	1 {
	    binary scan [binary format B32 [format "%032s" [string range $instr 6 10]]] I* DR
	    set DR R$DR
	    binary scan [binary format B32 [format "%032s" [string range $instr 11 15]]] I* SR1
	    set SR1 R$SR1
	    binary scan [binary format B32 [format "%032s" [string range $instr 27 31]]] I* SR2
	    set LIT $SR2
	    set SR2 R$SR2	    
	}
	2 {
	    binary scan [binary format B32 [format "%032s" [string range $instr 6 10]]] I* DR
	    set DR R$DR
	    binary scan [binary format B32 [format "%032s" [string range $instr 11 15]]] I* SR1
	    set SR1 R$SR1
	    binary scan [binary format B32 [format "%032s" [string range $instr 16 31]]] I* LIT	    
	}
	3 {
	    binary scan [binary format B32 [format "%032s" [string range $instr 6 10]]] I* DR
	    set DR R$DR
	    binary scan [binary format B32 [format "%032s" [string range $instr 27 31]]] I* SR1
	    set SR1 R$SR1
	    binary scan [binary format B32 [format "%032s" [string range $instr 16 31]]] I* LIT	    
	}
	4 {
	    binary scan [binary format B32 [format "%032s" [string range $instr 11 15]]] I* CONDR
	    set CONDR R$CONDR
	    binary scan [binary format B32 [format "%032s" [string range $instr 27 31]]] I* JUMPR
	    set JUMPR R$JUMPR
	    binary scan [binary format B32 [format "%032s" [string range $instr 16 31]]] I* LIT	    
	}
	5 {
	    binary scan [binary format B32 [format "%032s" [string range $instr 27 31]]] I* JUMPRtemp
	    set JUMPR R$JUMPRtemp
	    set SR1 R$JUMPRtemp
	}
	U {set txt "UNKNOWN OPCODE!!!  $opcode"; set ins "UNKNOWN OPCODE!!!"; set mne "UNKNOWN OPCODE!!!  $opcode"}
	N {set txt "NO DATA"; set ins "NO DATA"; set mne "NO DATA"}
    } 
    
    # Aplicaci'on de la substitucin y retorno del resultado
    set res [list [subst -nocommands $ins] [subst -nocommands $txt] [subst -nocommands $mne]]

    return $res
} 


#
# Procedura de inicilizacin de ciertas variables y sobre todo, inicializacin
# del array Instr que permite interpretar una instruccin.
# El array est compuesto por varias formas de escribir cada instruccin.
# Primero el "opcode" que permitir reconocer la instruccin. Despus su
# nombre, seguido por el detalle de la instruccin y finalmente la instruccin
# bajo la forma de codigo ensamblador genrico.
# Algunas instrucciones estn completadas por el "modifier" que las
# caracteriza.
# El ordn de introduccin de las instruciones en el array es el orden
# alfabetico, permitiendo al menu del breakpoint de instruccin obtenerlas
# en ese orden simplemente recorriendo el array.
#
proc init { } {
    global Instr EntryVal vieuxPC

    set EntryVal 0
    set vieuxPC 0
    
    # Inicializacin del array Instr
    set Instr(1,bin) 000101;  set Instr(1,fonc) ADD; set Instr(1,descr) "\$DR <= \[\$SR1\] + \[\$SR2\]"; set Instr(1,classe) 1; set Instr(1,mnemonic) "ADD \$DR, \$SR1, \$SR2"
    set Instr(2,bin) 100101;  set Instr(2,fonc) ADDI; set Instr(2,descr) "\$DR <= \[\$SR1\] + \$LIT"; set Instr(2,classe) 2; set Instr(2,mnemonic) "ADDI \$DR, \$SR1, \$LIT"
    set Instr(3,bin) 000100;  set Instr(3,fonc) AND; set Instr(3,descr) "\$DR <= \[\$SR1\] AND \[\$SR2\]"; set Instr(3,classe) 1; set Instr(3,mnemonic) "AND \$DR, \$SR1, \$SR2"
    set Instr(4,bin) 100100;  set Instr(4,fonc) ANDI; set Instr(4,descr) "\$DR <= \[\$SR1\] AND \$LIT"; set Instr(4,classe) 2; set Instr(4,mnemonic) "ANDI \$DR, \$SR1, \$LIT"
    set Instr(5,bin) 011101;  set Instr(5,fonc) BITCLEAR; set Instr(5,descr) "\$SR1{\[\$SR2\]} <= '0'; \$DR <= \[\$SR1\]"; set Instr(5,classe) 1; set Instr(5,mnemonic) "BITCLEAR \$DR, \$SR1, \$SR2"
    set Instr(6,bin) 111101;  set Instr(6,fonc) BITCLEARI; set Instr(6,descr) "\$SR1{\$LIT} <= '0'; \$DR <= \[\$SR1\]"; set Instr(6,classe) 1; set Instr(6,mnemonic) "BITCLEARI \$DR, \$SR1, \$LIT"
    set Instr(7,bin) 011100;  set Instr(7,fonc) BITSET; set Instr(7,descr) "\$SR1{\[\$SR2\]} <= '1'; \$DR <= \[\$SR1\]"; set Instr(7,classe) 1; set Instr(7,mnemonic) "BITSET \$DR, \$SR1, \$SR2"
    set Instr(8,bin) 111100;  set Instr(8,fonc) BITSETI; set Instr(8,descr) "\$SR1{\$LIT} <= '1'; \$DR <= \[\$SR1\]"; set Instr(8,classe) 1; set Instr(8,mnemonic) "BITSETI \$DR, \$SR1, \$LIT"
    set Instr(9,bin) 001110;  set Instr(9,fonc) BNE; set Instr(9,descr) "IF \$CONDR < \"00..0\" THEN PC <= \[PC\] + \[\$JUMPR\]"; set Instr(9,classe) 4; set Instr(9,mnemonic) "BNE \$CONDR, \$JUMPR"
    set Instr(10,bin) 101110;  set Instr(10,fonc) BNEI; set Instr(10,descr) "IF \$CONDR < \"00..0\" THEN PC <= \[PC\] + \$LIT"; set Instr(10,classe) 4; set Instr(10,mnemonic) "BNEI \$CONDR, \$LIT"
    set Instr(11,bin) 000111;  set Instr(11,fonc) BNZE; set Instr(11,descr) "IF \$CONDR <> \"00..0\" THEN PC <= \[PC\] + \[\$JUMPR\]"; set Instr(11,classe) 4; set Instr(11,mnemonic) "BNZE \$CONDR, \$JUMPR"
    set Instr(12,bin) 100111;  set Instr(12,fonc) BNZEI; set Instr(12,descr) "IF \$CONDR <> \"00..0\" THEN PC <= \[PC\] + \$LIT"; set Instr(12,classe) 4; set Instr(12,mnemonic) "BNZEI \$CONDR, \$LIT"
    set Instr(13,bin) 010111;  set Instr(13,fonc) BrNE; set Instr(13,descr) "IF \$CONDR < \"00..0\" THEN PC <= \[\$JUMPR\]"; set Instr(13,classe) 4; set Instr(13,mnemonic) "BrNE \$CONDR, \$JUMPR"
    set Instr(14,bin) 110111;  set Instr(14,fonc) BrNEI; set Instr(14,descr) "IF \$CONDR < \"00..0\" THEN PC <= \$LIT"; set Instr(14,classe) 4; set Instr(14,mnemonic) "BrNEI \$CONDR, \$LIT"
    set Instr(15,bin) 010001;  set Instr(15,fonc) BrNZE; set Instr(15,descr) "IF \$CONDR <> \"00..0\" THEN PC <= \[\$JUMPR\]"; set Instr(15,classe) 4; set Instr(15,mnemonic) "BrNZE \$CONDR, \$JUMPR"
    set Instr(16,bin) 110001;  set Instr(16,fonc) BrNZEI; set Instr(16,descr) "IF \$CONDR <> \"00..0\" THEN PC <= \$LIT"; set Instr(16,classe) 4; set Instr(16,mnemonic) "BrNZEI \$CONDR, \$LIT"
    set Instr(17,bin) 010000;  set Instr(17,fonc) BrZE; set Instr(17,descr) "IF \$CONDR == \"00..0\" THEN PC <= \[\$JUMPR\]"; set Instr(17,classe) 4; set Instr(17,mnemonic) "BrZE \$CONDR, \$JUMPR"
    set Instr(18,bin) 110000;  set Instr(18,fonc) BrZEI; set Instr(18,descr) "IF \$CONDR == \"00..0\" THEN PC <= \$LIT"; set Instr(18,classe) 4; set Instr(18,mnemonic) "BrZEI \$CONDR, \$LIT"
    set Instr(19,bin) 001100;  set Instr(19,fonc) BZE; set Instr(19,descr) "IF \$CONDR == \"00..0\" THEN PC <= \[PC\] + \[\$JUMPR\]"; set Instr(19,classe) 4; set Instr(19,mnemonic) "BZE \$CONDR, \$JUMPR"
    set Instr(20,bin) 101100;  set Instr(20,fonc) BZEI; set Instr(20,descr) "IF \$CONDR == \"00..0\" THEN PC <= \[PC\] + \$LIT"; set Instr(20,classe) 4; set Instr(20,mnemonic) "BZEI \$CONDR, \$LIT"
    set Instr(21,bin) 010101;  set Instr(21,fonc) CALL; set Instr(21,descr) "MEM{\[SP\]} <= \[PC\]; SP <= \[SP\] + 1; PC <= \[\$JUMPR\]"; set Instr(21,classe) 5; set Instr(21,mnemonic) "CALL \$JUMPR"
    set Instr(22,bin) 001111;  set Instr(22,fonc) JUMP; set Instr(22,descr) "PC <= \[PC\] + \[\$JUMPR\]"; set Instr(22,classe) 5; set Instr(22,mnemonic) "JUMP \$JUMPR"
    set Instr(23,bin) 101111;  set Instr(23,fonc) JUMPI; set Instr(23,descr) "PC <= \[PC\] + \$LIT"; set Instr(23,classe) 2; set Instr(23,mnemonic) "JUMPI \$LIT"
    set Instr(24,bin) 010010;  set Instr(24,fonc) JUMPr; set Instr(24,descr) "PC <= \[\$JUMPR\]"; set Instr(24,classe) 5; set Instr(24,mnemonic) "JUMPr \$JUMPR"
    set Instr(25,bin) 110010;  set Instr(25,fonc) JUMPrI; set Instr(25,descr) "PC <= \$LIT"; set Instr(25,classe) 2; set Instr(25,mnemonic) "JUMPrI \$LIT"
    set Instr(26,bin) 010011;  set Instr(26,fonc) LOAD; set Instr(26,descr) "\$DR <= MEM (\[\$SR1\] + \[\$SR2\])"; set Instr(26,classe) 1; set Instr(26,mnemonic) "LOAD \$DR, \$SR1, \$SR2"
    set Instr(27,bin) 110011;  set Instr(27,fonc) LOADI; set Instr(27,descr) "\$DR <= MEM {\[\$SR1\] + \$LIT}"; set Instr(27,classe) 2; set Instr(27,mnemonic) "LOADI \$DR, \$SR1, \$LIT"
    set Instr(28,bin) 011011;  set Instr(28,fonc) MOVE; set Instr(28,descr) "\$DR <= \[\$SR1\]"; set Instr(28,classe) 3; set Instr(28,mnemonic) "MOVE \$DR, \$SR1"
    set Instr(29,bin) 111011;  set Instr(29,fonc) MOVEH; set Instr(29,descr) "\$DR {31 downto 16} <= \$LIT; \$DR {15 downto 0} <= \"00..0\""; set Instr(29,modif) 1000; set Instr(29,classe) 3; set Instr(29,mnemonic) "MOVEH \$DR, \$LIT"
    set Instr(30,bin) 111011;  set Instr(30,fonc) MOVEL; set Instr(30,descr) "\$DR {31 downto 16} <= \$LIT {15} ; \$DR {15 downto 0} <= \$LIT"; set Instr(30,modif) 0000; set Instr(30,classe) 3; set Instr(30,mnemonic) "MOVEL \$DR, \$LIT"
    set Instr(31,bin) 111011;  set Instr(31,fonc) MVNZCOU; set Instr(31,descr) "\$DR <= \[\$STR\]"; set Instr(31,modif) 0100; set Instr(31,classe) 3; set Instr(31,mnemonic) "MVNZCOU"
    set Instr(32,bin) 111011;  set Instr(32,fonc) MVSPH; set Instr(32,descr) "SP{31 downto 16} <= \$LIT"; set Instr(32,modif) 1010; set Instr(32,classe) 3; set Instr(32,mnemonic) "MVSPH \$LIT"
    set Instr(33,bin) 111011;  set Instr(33,fonc) MVSPL; set Instr(33,descr) "SP{15 downto 0} <= \$LIT"; set Instr(33,modif) 0010; set Instr(33,classe) 3; set Instr(33,mnemonic) "MVSPL \$LIT"
    set Instr(34,bin) 000000;  set Instr(34,fonc) NOP; set Instr(34,descr) "PC <= \[PC\] + 1"; set Instr(34,classe) 1; set Instr(34,mnemonic) "NOP"
    set Instr(35,bin) 000011;  set Instr(35,fonc) NOR; set Instr(35,descr) "\$DR <= \[\$SR1\] NOR \[\$SR2\]"; set Instr(35,classe) 1; set Instr(35,mnemonic) "NOR \$DR, \$SR1, \$SR2"
    set Instr(36,bin) 100011;  set Instr(36,fonc) NORI; set Instr(36,descr) "\$DR <= \[\$SR1\] NOR \$LIT"; set Instr(36,classe) 2; set Instr(36,mnemonic) "NORI \$DR, \$SR1, \$LIT"
    set Instr(37,bin) 100111;  set Instr(37,fonc) NOT; set Instr(37,descr) "\$DR <= NOT\[\$SR1\]"; set Instr(37,classe) 3; set Instr(37,mnemonic) "NOT \$DR, \$SR1"
    set Instr(38,bin) 100110;  set Instr(38,fonc) NOTI; set Instr(38,descr) "\$DR <= NOT \$LIT"; set Instr(38,classe) 3; set Instr(38,mnemonic) "NOTI \$DR, \$LIT"
    set Instr(39,bin) 000001;  set Instr(39,fonc) OR; set Instr(39,descr) "\$DR <= \[\$SR1\] OR \[\$SR2\]"; set Instr(39,classe) 1; set Instr(39,mnemonic) "OR \$DR, \$SR1, \$SR2"
    set Instr(40,bin) 100001;  set Instr(40,fonc) ORI; set Instr(40,descr) "\$DR <= \[\$SR1\] OR \$LIT"; set Instr(40,classe) 2; set Instr(40,mnemonic) "ORI \$DR, \$SR1, \$LIT"
    set Instr(41,bin) 011010;  set Instr(41,fonc) POP; set Instr(41,descr) "\$DR <= MEM{\[SP\]}; SP <= \[SP\] - 1"; set Instr(41,classe) 1; set Instr(41,mnemonic) "POP \$DR"
    set Instr(42,bin) 011001;  set Instr(42,fonc) PUSH; set Instr(42,descr) "MEM{\[SP\]} <= \[\$SR1\]; SP <= \[SP\] + 1"; set Instr(42,classe) 5; set Instr(42,mnemonic) "PUSH \$SR1"
    set Instr(43,bin) 111001;  set Instr(43,fonc) PUSHI; set Instr(43,descr) "MEM{\[SP\]} <= \$LIT; SP <= \[SP\] + 1"; set Instr(43,classe) 2; set Instr(43,mnemonic) "PUSHI \$LIT"
    set Instr(44,bin) 011111;  set Instr(44,fonc) RANDOMIZE; set Instr(44,descr) "\$DR <= \[LFSR\]"; set Instr(44,classe) 1; set Instr(44,mnemonic) "RANDOMIZE \$DR"
    set Instr(45,bin) 011110;  set Instr(45,fonc) RANDOMSET; set Instr(45,descr) "LFSR <= \[\$SR1\]"; set Instr(45,classe) 5; set Instr(45,mnemonic) "RANDOMSET \$SR1"
    set Instr(46,bin) 111110;  set Instr(46,fonc) RANDOMSETI; set Instr(46,descr) "LFSR <= \$LIT"; set Instr(46,classe) 2; set Instr(46,mnemonic) "RANDOMSETI \$LIT"
    set Instr(47,bin) 011000;  set Instr(47,fonc) RET; set Instr(47,descr) "PC <= MEM{\[SP\]}; SP <= \[SP\] - 1"; set Instr(47,classe) 1; set Instr(47,mnemonic) "RET"
    set Instr(48,bin) 010110;  set Instr(48,fonc) RETI; set Instr(48,descr) "PC <= MEM{SP}; SP <= \[SP\] - 1; IM restored from the internal stack used for interrupt masks"; set Instr(48,classe) 1; set Instr(48,mnemonic) "RETI"
    set Instr(49,bin) 001000;  set Instr(49,fonc) ROR; set Instr(49,descr) "\$DR <= \[\$SR1\] >> \[\$SR2\]; \$SR1 {31} <= \[\$SR1 {0}\]"; set Instr(49,classe) 1; set Instr(49,mnemonic) "ROR \$DR, \$SR1, \$SR2"
    set Instr(50,bin) 101000;  set Instr(50,fonc) RORI; set Instr(50,descr) "\$DR <= \[\$SR1\] >> \$LIT; \$SR1 {31} <= \[\$SR1 {0}\]"; set Instr(50,classe) 2; set Instr(50,mnemonic) "RORI \$DR, \$SR1, \$LIT"
    set Instr(51,bin) 111011;  set Instr(51,fonc) SETMASK; set Instr(51,descr) "IM <= \$LIT"; set Instr(51,modif) 0001; set Instr(51,classe) 3; set Instr(51,mnemonic) "SETMASK \$LIT"
    set Instr(52,bin) 001001;  set Instr(52,fonc) SLL; set Instr(52,descr) "\$DR <= \[\$SR1\] << \[\$SR2\]"; set Instr(52,classe) 1; set Instr(52,mnemonic) "SLL \$DR, \$SR1, \$SR2"
    set Instr(53,bin) 101001;  set Instr(53,fonc) SLLI; set Instr(53,descr) "\$DR <= \[\$SR1\] << \$LIT"; set Instr(53,classe) 2; set Instr(53,mnemonic) "SLLI \$DR, \$SR1, \$LIT"
    set Instr(54,bin) 101010;  set Instr(54,fonc) SLRI; set Instr(54,descr) "\$DR <= \[\$SR1\] >> \$LIT"; set Instr(54,classe) 2; set Instr(54,mnemonic) "SLRI \$DR, \$SR1, \$LIT"
    set Instr(55,bin) 001011;  set Instr(55,fonc) SRA; set Instr(55,descr) "\$DR <= \[\$SR1\] >> \[\$SR2\]; \$SR1 {31 downto \$SR2} <= \[\$SR1 {31}\]"; set Instr(55,classe) 1; set Instr(55,mnemonic) "SRA \$DR, \$SR1, \$SR2"
    set Instr(56,bin) 101011;  set Instr(56,fonc) SRAI; set Instr(56,descr) "\$DR <= \[\$SR1\] >> \$LIT; \$SR1 {31 downto \$LIT} <= \[\$SR1 {31}\]"; set Instr(56,classe) 2; set Instr(56,mnemonic) "SRAI \$DR, \$SR1, \$LIT"
    set Instr(57,bin) 001010;  set Instr(57,fonc) SRL; set Instr(57,descr) "\$DR <= \[\$SR1\] >> \[\$SR2\]"; set Instr(57,classe) 1; set Instr(57,mnemonic) "SRL \$DR, \$SR1, \$SR2"
    set Instr(58,bin) 010100;  set Instr(58,fonc) STORE; set Instr(58,descr) "MEM(\[\$SR1\]) <= \[\$SR2\]"; set Instr(58,classe) 1; set Instr(58,mnemonic) "STORE \$SR1, \$SR2"
    set Instr(59,bin) 110100;  set Instr(59,fonc) STOREI; set Instr(59,descr) "MEM(\[\$CONDR\]) <= \$LIT"; set Instr(59,classe) 4; set Instr(59,mnemonic) "STOREI \$CONDR, \$LIT"
    set Instr(60,bin) 000110;  set Instr(60,fonc) SUBB; set Instr(60,descr) "\$DR <= \[\$SR1\] - \[\$SR2\]"; set Instr(60,classe) 1; set Instr(60,mnemonic) "SUBB \$DR, \$SR1, \$SR2"
    set Instr(61,bin) 100110;  set Instr(61,fonc) SUBBI; set Instr(61,descr) "\$DR <= \[\$SR1\] - \$LIT"; set Instr(61,classe) 2; set Instr(61,mnemonic) "SUBBI \$DR, \$SR1, \$LIT"
    set Instr(62,bin) 000010;  set Instr(62,fonc) XOR; set Instr(62,descr) "\$DR <= \[\$SR1\] XOR \[\$SR2\]"; set Instr(62,classe) 1; set Instr(62,mnemonic) "XOR \$DR, \$SR1, \$SR2"
    set Instr(63,bin) 100010;  set Instr(63,fonc) XORI; set Instr(63,descr) "\$DR <= \[\$SR1\] XOR \$LIT"; set Instr(63,classe) 2; set Instr(63,mnemonic) "XORI \$DR, \$SR1, \$LIT"
    set Instr(64,fonc) "UNKNOWN OPCODE!!!"
}
  