#########################
#########################
##                     ##
## Implementado por:   ##
## Jorge-Enrique Vidal ##
## EPFL/UPC            ##
## 2003-2004           ##
##                     ##
#########################
#########################

###############################################################################
# Este fichero contiene todos los elementos que permiten la creacin de la    #
# interfaz. Contiene la declaracin de las variables globales mas importantes #
# y la funcin principal que esta encargada de lanzar la interfaz.            #
###############################################################################



# Variables globales para los puntos de parada. Cada punto de parada tiene su
# valor y una variable para saber si est o no activado.
set BpRamWriteAddrEn 0
set BpRamWriteAddr 0
set BpRamWriteDaEn 0
set BpRamWriteDa 0
set BpRamReadAddrEn 0
set BpRamReadAddr 0
set BpRamReadDaEn 0
set BpRamReadDa 0
set BpRegWriteAddrEn 0
set BpRegWriteAddr 0
set BpRegWriteDaEn 0
set BpRegWriteDa 0
set BpInstrEn 0
set BpInstrDa ADD
set BpRegRead1AddrEn 0
set BpRegRead1Addr 0
set BpRegRead1DaEn 0
set BpRegRead1Da 0
set BpRegRead2AddrEn 0
set BpRegRead2Addr 0
set BpRegRead2DaEn 0
set BpRegRead2Da 0
 
# Variables globales para los parametros de la ventana View Options
set Viewbr Decimal
set Viewram Decimal
set Viewrom Hexadecimal
set Viewdata Binary
set Viewins Decimal

# Variables globales para la visualizacin de la Ram
set BeginRam 0
#set VariationRam 1024
set VariationRam 0
#set Ramsize [expr {round(pow(2,[examine -value /ram_bloc/bloc_memoria/addr_width]))}]
set Ramsize 256

# Numero de lineas visualizadas para la Rom, Ram y l banco de registros
set NumLinesRom 1024
set NumLinesRegfile 32
#set NumLinesRam [expr {round(pow(2,[examine -value /ram_bloc/bloc_memoria/addr_width]))}]
set NumLinesRam 256

# Variables de configuracin para que el programa pueda saber la linea
# seleccionada con el boton derecho del raton.
set pix_per_line 16
set start_disp_rom 2
set start_disp_regfile 2
set start_disp_ram 3

# Numero de lineas visibles para la Ram, Rom y banco de registros
set LinesWinrom 30
set LinesWinregfile 14
set LinesWinram 14

set tempinstr 0
set StepPC 0


#
# Procedura principal encargada de lanzar la interfaz y ejecutar el programa
#
proc draw_interface {} {
    
    # Si la ventana ya existe se destruye antes
    if {[winfo exists .main_window]} {
	destroy .main_window
    }
    
    # Parametros de visualizacin de la ventana principal
    toplevel .main_window
    wm geometry .main_window 860x710+120+0
    wm positionfrom .main_window user
    wm sizefrom .main_window user
    wm title .main_window {Functional simulaton tool - VDD}
    wm resizable .main_window 0 0
    
    # Creacin de la interfaz e inicializaciones
    create_canvas .main_window.i
    create_buttons .main_window.i
    init
    draw_view .main_window.i
    draw_Registers .main_window.i 11.5c 16.85c
    init_tabs

    # Lanzamiento de las proceduras de espera de cambios de seal y
    # actualizacin de las variables
    draw_rom
    draw_banc_reg
    draw_ram
    update_DataView
    wait_signal
}


#
# Procedura creadora del canva que contendra a todos los objetos creados.
# El parametro es el nombre de la ventana "padre"
#
proc create_canvas { Obj } {
    
    frame $Obj -bg gray -relief flat
    pack configure $Obj -expand 1 -fill both
    canvas $Obj.c -height 20c -width 20c -bg grey -relief flat
    pack configure $Obj.c -expand 1 -fill both
    pack $Obj.c -in $Obj

    pack $Obj
}


#
# Procedura creadora de los botones que se situan en la parte superior de la
# ventana principal.
# El parametro es el nombre de la ventana "padre"
#
proc create_buttons { Obj } {
    global now StepPC
    
    set xpos 0.55c

    # Creacin del botn step
    set ImageName [pwd]/Interface/Images/step.gif
    image create photo Icone1 -file $ImageName
    set rb $Obj.step
    button $rb -command "transcribe step" -image Icone1
    pack $rb
    $Obj.c create window 0.8c $xpos -window $rb
    
    # Creacin del botn step -over
    set ImageName [pwd]/Interface/Images/step_ovr.gif
    image create photo Icone2 -file $ImageName
    set rb $Obj.step_over
    button $rb -command "transcribe step -over" -image Icone2
    pack $rb
    $Obj.c create window 1.7c $xpos -window $rb
    
    # Creacin del botn paso a paso por instruccin
    set rb $Obj.step_instr
    button $rb -text "Step PC" -command {set StepPC 1; transcribe run -all}
    pack $rb
    $Obj.c create window 3.1c $xpos -window $rb
    
    # Creacin del botn run -all
    set ImageName [pwd]/Interface/Images/runall.gif
    image create photo Icone3 -file $ImageName
    set rb $Obj.runall
    button $rb -command "transcribe run -all" -image Icone3
    pack $rb
    $Obj.c create window 5.0c $xpos -window $rb
    
    # Creacin del botn de parada de la simulacin
    set ImageName [pwd]/Interface/Images/break.gif
    image create photo Icone4 -file $ImageName
    set rb $Obj.break
    button $rb -command "vsim_break; update_DataView" -image Icone4
    pack $rb
    $Obj.c create window 5.9c $xpos -window $rb

    # Creacin del botn de entrada del numero de ns que se quieren
    # efectuar en el run.
    set EntryVal 0
    set rb $Obj.textentry
    entry $rb -justify right -width 7 -textvariable EntryVal
    pack $rb
    $Obj.c create window 7.7c $xpos -window $rb

    # Creacin del texto ns
    set lb $Obj.label
    label $lb -text ns -bg grey
    pack $lb
    $Obj.c create window 8.5c $xpos -window $lb

    # Creacin del botn run
    set rb $Obj.runx
    button $rb -command {run_x_ns $EntryVal} -text "run"
    pack $rb
    $Obj.c create window 9.2c $xpos -window $rb
    
    # Creacin del botn View Options
    set rb $Obj.textconf
    button $rb -text "View Options" -command {textconf}
    pack $rb
    $Obj.c create window 11.7c $xpos -window $rb

    # Creacin del botn Breakpoints
    set rb $Obj.breakpoint
    button $rb -command {breakp} -text "Breakpoints"
    pack $rb
    $Obj.c create window 15.0c $xpos -window $rb

    # Creacin del indicador de tiempo
    set lb $Obj.time
    label $lb -text "Runing Time: $now ns" -bg grey
    pack $lb
    $Obj.c create window 18.4c $xpos -window $lb

    # Creacin del botn restart
    set ImageName [pwd]/Interface/Images/restart.gif
    image create photo Icone5 -file $ImageName
    set rb $Obj.restart
    button $rb -command {
	transcribe restart -f 
	.main_window.i.rom.data yview scroll -1024 units
	init_tabs
	update_DataView} -image Icone5
    pack $rb
    $Obj.c create window 21.9c $xpos -window $rb
}


#
# Procedura que permite a la simulacin avanzar de un cierto numero de
# ns dado en entrada.
#
proc run_x_ns { Val } {
    global now
    transcribe run $Val ns
    .main_window.i.time configure -text "Runing Time : $now ns" 
}


#
# Procedura creadora de la visualizacin de la Rom, la Ram y el banco
# de registros.
#
# Cada elemento posee su barra de desplazamiento al lado del texto visualizado.
# Para poder visualizar los elementos creados, se tiene que emplear el
# comando "pack" con cada uno de ellos.
# El parametro es el nombre de la ventana "padre".
#
proc draw_view { Obj } {
    global Viewbr Viewram Viewrom

    # Creacin de la visualizacin de la Rom
    frame $Obj.rom
    pack configure $Obj.rom -expand 0 -fill x 
    
    # Creacin y "packing" de las barras de desplazamiento
    scrollbar $Obj.rom.scrollv -orient vertical -command "$Obj.rom.data yview"
    scrollbar $Obj.rom.scrollh -orient horizontal -command "$Obj.rom.data xview"
    pack configure $Obj.rom.scrollv -side right -fill y -expand 0
    pack configure $Obj.rom.scrollh -side bottom -fill x -expand 0
    
    # Creacin del texto
    text $Obj.rom.data -background white -yscrollcommand "$Obj.rom.scrollv set" \
	-xscrollcommand "$Obj.rom.scrollh set" -wrap none
    pack configure $Obj.rom.data -side top -expand 1 -fill both
    
    # Creacin y visualizacin del conjunto en el canva
    pack $Obj.rom -side left
    $Obj.c create window 6.0c 8.3c -window $Obj.rom -height 13.3c -width 9.5c

    # Creacin del titulo encima del texto
    label $Obj.romtitle -text "ROM Data  ($Viewrom View)" -bg grey80 -justify right \
	-relief raise -padx 3c
    pack $Obj.romtitle
    $Obj.c create window 6.0c 1.4c -window $Obj.romtitle -height 0.5c -width 9.5c  
     
    # Deteccin de un "clic" efectuado con el botn derecho en esta ventana y
    # llamada de la procedura de insercin de puntos de parada
    bind .main_window.i.rom.data <Button-3> {insertBp %y}



    # Creacin de la visualizacin del banco de registros
    frame $Obj.regfile
    pack configure $Obj.regfile -expand 0 -fill x 
    
    # Creacin y "packing" de la barra de desplazamiento
    scrollbar $Obj.regfile.scrollv -orient vertical -command "$Obj.regfile.data yview"
    pack configure $Obj.regfile.scrollv -side right -fill y -expand 0
    
    # Creacin del texto
    text $Obj.regfile.data -background white -yscrollcommand "$Obj.regfile.scrollv set" \
	-wrap none
    pack configure $Obj.regfile.data -side top -expand 1 -fill both
    
    # Creacin y visualizacin del conjunto en el canva
    pack $Obj.regfile -side left
    $Obj.c create window 17.0c 4.72c -window $Obj.regfile -height 6.15c -width 8.7c

    # Creacin del titulo encima del texto
    label $Obj.regfiletitle -text "Regfile Data  ($Viewbr View)" -bg grey80 -justify right \
	-relief raise -padx 2.5c
    pack $Obj.regfiletitle
    $Obj.c create window 17.0c 1.4c -window $Obj.regfiletitle -height 0.5c -width 8.7c
     
    # Deteccin de un "clic" efectuado con el botn derecho en esta ventana y
    # llamada de la procedura de insercin de un valor en el banco de registros
    bind .main_window.i.regfile.data <Button-3> {insertValue %y Regfile regfile}



    # Creacin de la visualizacin de la Ram
    frame $Obj.ram
    pack configure $Obj.ram -expand 0 -fill x 
    
    # Creacin y "packing" de la barra de desplazamient
    scrollbar $Obj.ram.scrollv -orient vertical -command "$Obj.ram.data yview"
    pack configure $Obj.ram.scrollv -side right -fill y -expand 0
    
    # Creacin del texto
    text $Obj.ram.data -background white -yscrollcommand "$Obj.ram.scrollv set" -wrap none
    pack configure $Obj.ram.data -side top -expand 1 -fill both
    
    # Creacin y visualizacin del conjunto en el canva
    pack $Obj.ram -side left
    $Obj.c create window 17.0c 11.85c -window $Obj.ram -height 6.15c -width 8.7c

    # Creacin del titulo encima del texto
    label $Obj.ramtitle -text "RAM Data  ($Viewram View)" -bg grey80 -justify right -relief raise \
	-padx 2.5c
    pack $Obj.ramtitle
    $Obj.c create window 17.0c 8.53c -window $Obj.ramtitle -height 0.5c -width 8.7c 

    # Deteccin de un "clic" efectuado con el botn derecho en esta ventana y
    # llamada de la procedura de insercin de un valor en la Ram
    bind .main_window.i.ram.data <Button-3> {insertValue %y Ram ram}
}


#
# Procedura que permite visualizar las seales y registros mas significativos.
#
# Los valores apareciendo en la misma columna son agrupados, escepto el valor que se situa
# debajo de todos los dems. Debido a que su tamao puede llegar a ser muy grande, se adjunta
# individualmente debajo de los dems valores.
# 
# Cada elemento es creado de la misma manera, uniendo un texto a una zona que hara aparecer
# el valor del elemento.
# Los parametros de entrada son el nombre de la ventana "padre", la posicin en x y en y
# del bloque de los valores.
#
proc draw_Registers { obj x y } {

    frame $obj.register -bg grey
    pack configure $obj.register -expand 0 -fill x

    # Creacin de los diferentes grupos de variables
    frame $obj.register.up -bg grey
    frame $obj.register.bottom -bg grey
    frame $obj.register.up.left -bg grey
    frame $obj.register.up.center -bg grey
    frame $obj.register.up.right -bg grey

    # Variable que definen la zona de visualizacin de un valor.
    # Se puede interpretar como el espacio entre dos columnas de valores.
    set leftval 33
    set centerval 37
    set rightval 3
    set bottomval 125

    # Creacin de la visualizacin del PC
    frame $obj.register.up.left.pc

    label $obj.register.up.left.pc.l -text "Register PC value:    " -bg grey
    label $obj.register.up.left.pc.v -text 0 -width $leftval -bg grey

    pack $obj.register.up.left.pc.l $obj.register.up.left.pc.v \
	-side left -anchor w -in $obj.register.up.left.pc 
    

    # Creacin de la visualizacin de SR1
    frame $obj.register.up.left.sr1
    
    label $obj.register.up.left.sr1.l -text "Register SR1 value:  " -bg grey
    label $obj.register.up.left.sr1.v -text 0 -width $leftval -bg grey    
    
    pack $obj.register.up.left.sr1.l $obj.register.up.left.sr1.v \
	-side left -anchor w -in $obj.register.up.left.sr1 
    
        
    # Creacin de la visualizacin de SR2
    frame $obj.register.up.left.sr2
    
    label $obj.register.up.left.sr2.l -text "Register SR2 value:  " -bg grey
    label $obj.register.up.left.sr2.v -text 0 -width $leftval -bg grey  

    pack $obj.register.up.left.sr2.l $obj.register.up.left.sr2.v \
	-side left -anchor w -in $obj.register.up.left.sr2 
    
 
    # Creacin de la visualizacin de DR
    frame $obj.register.up.left.dr
    
    label $obj.register.up.left.dr.l -text "Register DR value:    " -bg grey
    label $obj.register.up.left.dr.v -text 0 -width $leftval -bg grey
    $obj.register.up.left.dr.v configure -justify right

    pack $obj.register.up.left.dr.l $obj.register.up.left.dr.v \
	-side left -anchor w -in $obj.register.up.left.dr 
    

    # Creacin de la visualizacin de la mscara de interrupcin
    frame $obj.register.up.left.im
    
    label $obj.register.up.left.im.l -text "Interrupt mask register value:  " \
	-bg grey
    label $obj.register.up.left.im.v -text 0 -width [expr {$leftval-7}] \
	-bg grey

    pack $obj.register.up.left.im.l $obj.register.up.left.im.v \
	-side left -anchor w -in $obj.register.up.left.im 


    # Creacin de la visualizacin del "mnemonic" de la instruccin corriente
    frame $obj.register.up.left.op
    
    label $obj.register.up.left.op.l -text "Instruction mnemonic:  " \
	-bg grey
    label $obj.register.up.left.op.v -text 0 -width [expr {$leftval-2}] -bg grey

    pack $obj.register.up.left.op.l $obj.register.up.left.op.v \
	-side left -anchor w -in $obj.register.up.left.op


    # Creacin de la visualizacin del detalle de la instruccin
    frame $obj.register.bottom.op 
    
    label $obj.register.bottom.op.l -text "Instruction detail:  " -bg grey
    label $obj.register.bottom.op.v -text 0 -width $bottomval -bg grey

    pack $obj.register.bottom.op.l $obj.register.bottom.op.v -side left
    

    # Creacin de la visualizacin del registro SP
    frame $obj.register.up.center.sp
    
    label $obj.register.up.center.sp.l -text "Stack Pointer Register value:    " \
	-bg grey
    label $obj.register.up.center.sp.v -text 0 -width $centerval -bg grey
    
    pack $obj.register.up.center.sp.l $obj.register.up.center.sp.v \
	-side left -anchor w -in $obj.register.up.center.sp 
    

    # Creacin de la visualizacin del valor de AHBI IN HADDR.
    frame $obj.register.up.center.ahbiinhaddr    
    label $obj.register.up.center.ahbiinhaddr.l -text "Bus AHBI IN HADDR value:     " \
	-bg grey
    label $obj.register.up.center.ahbiinhaddr.v -text 0 -width $centerval -bg grey

    pack $obj.register.up.center.ahbiinhaddr.l $obj.register.up.center.ahbiinhaddr.v \
	    -side left -anchor w -in $obj.register.up.center.ahbiinhaddr 


    # Creacin de la visualizacin del valor de AHB OUT HADDR.
    frame $obj.register.up.center.ahbiouthaddr
    
    label $obj.register.up.center.ahbiouthaddr.l -text "Bus AHBI OUT HADDR value: " \
	-bg grey
    label $obj.register.up.center.ahbiouthaddr.v -text 0 -width $centerval -bg grey
    
    pack $obj.register.up.center.ahbiouthaddr.l $obj.register.up.center.ahbiouthaddr.v \
	    -side left -anchor w -in $obj.register.up.center.ahbiouthaddr 


    # Creacin de la visualizacin del valor de AHB OUT DATA.
    frame $obj.register.up.center.ahboutdata
    
    label $obj.register.up.center.ahboutdata.l -text "Bus AHB OUT DATA value:     " \
	-bg grey
    label $obj.register.up.center.ahboutdata.v -text 0 -width $centerval -bg grey
    
    pack $obj.register.up.center.ahboutdata.l $obj.register.up.center.ahboutdata.v \
	    -side left -anchor w -in $obj.register.up.center.ahboutdata 


    # Creacin de la visualizacin del valor de AHB IN DATA.
    frame $obj.register.up.center.ahbindata
    
    label $obj.register.up.center.ahbindata.l -text "Bus AHB IN DATA value:         " \
	-bg grey
    label $obj.register.up.center.ahbindata.v -text 0 -width $centerval -bg grey
    
    pack $obj.register.up.center.ahbindata.l $obj.register.up.center.ahbindata.v \
	    -side left -anchor w -in $obj.register.up.center.ahbindata 


    # Se aade una linea vaca para poder alinear las visualizaciones anteriores con las de
    # las otras columnas
    frame $obj.register.up.center.blank -height 19 -bg grey


    # Creacin de la visualizacin del valor de AHB IN SEL.
    frame $obj.register.up.right.ahbinsel
    
    label $obj.register.up.right.ahbinsel.l -text "AHB IN SEL value:            " \
	-bg grey
    label $obj.register.up.right.ahbinsel.v -text 0 -width $rightval -bg grey    

    pack $obj.register.up.right.ahbinsel.l $obj.register.up.right.ahbinsel.v \
	    -side left -anchor w -in $obj.register.up.right.ahbinsel 


    # Creacin de la visualizacin del valor de AHB IN READY.
    frame $obj.register.up.right.ahbinready
    
    label $obj.register.up.right.ahbinready.l -text "AHB IN READY value:      " \
	-bg grey
    label $obj.register.up.right.ahbinready.v -text 0 -width $rightval -bg grey
    
    pack $obj.register.up.right.ahbinready.l $obj.register.up.right.ahbinready.v \
	    -side left -anchor w -in $obj.register.up.right.ahbinready 


    # Creacin de la visualizacin del valor de AHB IN WRITE.
    frame $obj.register.up.right.ahbinwrite
    
    label $obj.register.up.right.ahbinwrite.l -text "AHB IN WRITE value:       " \
	-bg grey
    label $obj.register.up.right.ahbinwrite.v -text 0 -width $rightval -bg grey
    
    pack $obj.register.up.right.ahbinwrite.l $obj.register.up.right.ahbinwrite.v \
	    -side left -anchor w -in $obj.register.up.right.ahbinwrite 


    # Creacin de la visualizacin del valor de AHB OUT SEL.
    frame $obj.register.up.right.ahboutsel
    
    label $obj.register.up.right.ahboutsel.l -text "AHB OUT SEL value:        " \
	-bg grey
    label $obj.register.up.right.ahboutsel.v -text 0 -width $rightval -bg grey

    pack $obj.register.up.right.ahboutsel.l $obj.register.up.right.ahboutsel.v \
	    -side left -anchor w -in $obj.register.up.right.ahboutsel 


    # Creacin de la visualizacin del valor de AHB OUT READY.
    frame $obj.register.up.right.ahboutready
    
    label $obj.register.up.right.ahboutready.l -text "AHB OUT READY value:   " -bg grey
    label $obj.register.up.right.ahboutready.v -text 0 -width $rightval -bg grey 

    pack $obj.register.up.right.ahboutready.l $obj.register.up.right.ahboutready.v \
	    -side left -anchor w -in $obj.register.up.right.ahboutready 


    # Creacin de la visualizacin del valor de AHB OUT WRITE.
    frame $obj.register.up.right.ahboutwrite
    
    label $obj.register.up.right.ahboutwrite.l -text "AHB OUT WRITE value:   " \
	-bg grey
    label $obj.register.up.right.ahboutwrite.v -text 0 -width $rightval -bg grey    

    pack $obj.register.up.right.ahboutwrite.l $obj.register.up.right.ahboutwrite.v \
	    -side left -anchor w -in $obj.register.up.right.ahboutwrite 
    

    # Unin de todos los bloques de texto y valor en diferentes grupos y "pack" de esos grupos.
    pack $obj.register.up.left.pc $obj.register.up.left.sr1 $obj.register.up.left.sr2 \
	$obj.register.up.left.dr $obj.register.up.left.im $obj.register.up.left.op -side top

    pack $obj.register.up.center.sp $obj.register.up.center.ahbiinhaddr \
	$obj.register.up.center.ahbiouthaddr $obj.register.up.center.ahboutdata \
	$obj.register.up.center.ahbindata $obj.register.up.center.blank -side top

    pack $obj.register.up.right.ahbinsel $obj.register.up.right.ahbinready \
	$obj.register.up.right.ahbinwrite $obj.register.up.right.ahboutsel \
	$obj.register.up.right.ahboutready $obj.register.up.right.ahboutwrite -side top

    pack $obj.register.up.left -side left
    pack $obj.register.up.center -side left
    pack $obj.register.up.right -side right

    pack $obj.register.bottom.op -side bottom
    pack $obj.register.up $obj.register.bottom -side top
    $obj.c create window $x $y -window $obj.register    
}





























































































































