#########################
#########################
##                     ##
## Implementado por:   ##
## Jorge-Enrique Vidal ##
## EPFL/UPC            ##
## 2003-2004           ##
##                     ##
#########################
#########################

##############################################################################
# Este fichero contiene diferentes proceduras que esperan un cambio de       #
# ciertas seales, actualizan la visualizacin y prueban si las condiciones  #
# para realizar un breakpoint se han cumplido.                               #
##############################################################################



#
# Procedura que inicializa la visualizacin de la Ram, del banco de registros
# y de sus respectivos arrays que contienen sus valores y permiten los cambios
# de formato.
#
proc init_tabs {} {
    global RegArray Viewbr RamArray Ramsize VariationRam BeginRam Viewram
 
    # Inicializacin del array de conversin del banco de registros
    foreach opcion {Binary Octal Hexadecimal Decimal} {
	switch $opcion {
	    Binary {set value --------------------------------}
	    Octal {set value -----------}
	    Hexadecimal {set value --------}
	    Decimal {set value ----------}
	}	
	for {set x 0} {$x < 32} {incr x} {
	    set RegArray($x,$opcion) $value
	}	
    }

    # Derechos de escritura y borramiento de la ventana
    .main_window.i.regfile.data configure -state normal
    
    for {set x 0} {$x < 32} {incr x} {
	.main_window.i.regfile.data delete 1.0 2.0
    }

    # Escritura en la ventana de las lineas vacias segn el formato deseado   
    for {set addr 0} {$addr < 32} {incr addr} {
	set line [format "%02u" $addr]
	.main_window.i.regfile.data insert end "$line $RegArray($addr,$Viewbr)"	    
	.main_window.i.regfile.data insert end "\n" 
    }

    # Quita el derecho de escritura y posiciona la ventana el la primera linea
    .main_window.i.regfile.data configure -state disabled
    .main_window.i.regfile.data yview scroll -32 units



    # Inicializacin del array de conversin de la Ram
    foreach opcion {Binary Octal Hexadecimal Decimal} {
	switch $opcion {
	    Binary {set value --------------------------------}
	    Octal {set value -----------}
	    Hexadecimal {set value --------}
	    Decimal {set value ----------}
	}	
	for {set x 0} {$x < $Ramsize} {incr x} {
	    set RamArray($x,$opcion) $value
	}	
    }

    # Derechos de escritura
    .main_window.i.ram.data configure -state normal

    # Borramiento de la ventana segn las opciones de visualizacin
    set end_display_ram [expr {$VariationRam+$BeginRam}]
    for {set x $BeginRam} {$x < $end_display_ram} {incr x} {
	.main_window.i.ram.data delete 1.0 2.0
    }

    # Escritura en la ventana de las lineas vacias segn el formato y la
    # configuracin deseados
    for {set addr $BeginRam} {$addr < $end_display_ram} {incr addr} {	
	set line [format "%04u" $addr]
	.main_window.i.ram.data insert end "$line $RamArray($addr,$Viewram)"	    
	.main_window.i.ram.data insert end "\n" 
    }
    
    # Quita el derecho de escritura y posiciona la ventana el la primera linea
    .main_window.i.ram.data configure -state disabled
    .main_window.i.ram.data yview scroll -$VariationRam units
}


#
# Procedura que recupera el contenido de la Rom y lo aade al array RomAray.
# Cada instruccin es aadida en sus cuatro formatos posibles para facilitar
# la conversin.
# Las intrucciones son visualizadas seguidas por el codigo asamblador
# recuperado por el interpretador.
# El array de breakpoints tambin es inicializado.
#
proc draw_rom {} {
    global RomArray Viewrom NumLinesRom
    
    # Recuperacin de las instrucciones
    for {set x 0} {$x < $NumLinesRom} {incr x} {
	set code [examine -value /rom_bloc/Memoria_ROM/mem($x)]
	
	# Cada instruccin es transformada en todos los formatos y aadida
	# al RomArray
	binary scan [binary format B32 [set code]] I* intval
	set RomArray($x,Binary) $code
	set RomArray($x,Decimal) [format "%010u" $intval]
	set RomArray($x,Octal) [string toupper [format "%011o" $intval]]
	set RomArray($x,Hexadecimal) [string toupper [format "%08x" $intval]]
	
	# Recuperacin del codigo ensamblador correspondiente y formateo
	# del numero de la linea
	set details [interpreter $code]
	set line [format "%04u" $x]
	
	# Escritura de la linea
	.main_window.i.rom.data insert end "  $line $code\t\t\t [lindex $details 2]"	    
	.main_window.i.rom.data insert end "\n"    		
    }
    
    # Supresin del derecho de escritura
    .main_window.i.rom.data configure -state disabled
    
    # Inicializacin del porcentage de una linia en la barra de desplazamiento
    global PercentLinerom
    .main_window.i.rom.data yview scroll 1 units
    set PercentLinerom [lindex [.main_window.i.rom.data yview] 0]
    .main_window.i.rom.data yview scroll -1 units

    # Inicializacin del array de los breakpoints del PC y del indicador de
    # sealizacin de la linea
    global RomBp RomLine
    for {set x 0} {$x < $NumLinesRom} {incr x} {
	set RomBp($x) 0
	set RomLine($x) 0
    }
    
    # Visualizacin el el formato especificado
    if {[string compare $Viewrom Binary] != 0} {
	update_Rom $Viewrom
    }
}


#
# Procedura que espera una lectura o una escritura en el banco de registros
# para actulizar la visualizacin o parar la simulacin en el caso que las
# condiciones de breakpoint sean cumplidas.
#
proc draw_banc_reg {} {
    global RegArray Viewbr AddrWriteReg DataInReg BpRegWriteAddrEn BpRegWriteAddr BpRegWriteDaEn BpRegWriteDa BpRegRead1AddrEn BpRegRead1Addr BpRegRead1DaEn BpRegRead1Da DataOutRead1 AddrRead1 BpRegRead2AddrEn BpRegRead2Addr BpRegRead2DaEn BpRegRead2Da DataOutRead2 AddrRead2
    
    # Inicializacion del porcentage de una linia en la barra de desplazamiento
    global PercentLineregfile
    .main_window.i.regfile.data yview scroll 1 units
    set PercentLineregfile [lindex [.main_window.i.regfile.data yview] 0]
    .main_window.i.regfile.data yview scroll -1 units

    # Supresin del derecho de escritura
    .main_window.i.regfile.data configure -state disabled

    set DataInReg initialisation
    set AddrWriteReg initialisation
    set DataOutRead1 initialisation
    set AddrRead1 initialisation
    set DataOutRead2 initialisation
    set AddrRead2 initialisation

    # Espera que el flanco del reloj sea descendiente. Prueba si el
    # microprocesador quiere escribir.
    when {/micro_bloc/regfile_bloc/clk = '0'} {
	if {[string compare [examine -value /micro_bloc/regfile_bloc/write] 1] == 0} {    
	    
	    # Recuperacin de la direccin
 	    set AddrWriteReg 00000000000[examine -value /micro_bloc/regfile_bloc/waddr]
 	    binary scan [binary format B16 $AddrWriteReg] S* addr_num
	    
	    # Recuperacin del data
 	    set DataInReg [examine -value /micro_bloc/regfile_bloc/datain]
	    
	    # Escritura de la linea en la ventana del banco de registros
	    write_line_BReg $addr_num

	    # Transformacin del data en entero
	    binary scan [binary format B32 $DataInReg] I* intval
	    
	    # Prueba si el breakpoint de direccin esta activo y si las
	    # condiciones estn cumplidas, para la simulacin abriendo la
	    # ventana de Breakpoint Report
	    if {$BpRegWriteAddrEn == 1} {
		if {[string compare $addr_num $BpRegWriteAddr] == 0} {
		    break_report_two_val RegFwa $addr_num [string toupper [format "%08x" $intval]]
		    transcribe stop
		}
	    }
	    
	    # Prueba el breakpoint de datos, de la misma manera que el
	    # precedente
	    if {$BpRegWriteDaEn == 1} {
		set tempvar [format "%i" 0x$BpRegWriteDa]
		set tempvar [string toupper [format "%08x" $tempvar]]
		if {[string compare [string toupper [format "%08x" $intval]] $tempvar] == 0} {
		    break_report_two_val RegFwd $tempvar $addr_num
		    transcribe stop
		}		
	    }
	} 
	
	# Prueba si hay un breakpoint de lectura segn la direccin del Read1	
	if {$BpRegRead1AddrEn == 1} {

	    # Recuperacin de la direccin
	    set AddrRead1 00000000000[examine -value /micro_bloc/regfile_bloc/raddr1]
	    binary scan [binary format B16 $AddrRead1] S* addr_num
	    
	    # Prueba si las condiciones estn cumplidas y en ese caso recupera
	    # los datos y llama la ventana Breakpoint Report antes de
	    # interrumpir la simulacin
	    if {[string compare $addr_num $BpRegRead1Addr] == 0} {
		set DataOutRead1 [examine -value /micro_bloc/regfile_bloc/u0/mem($addr_num)]
		binary scan [binary format B32 $DataOutRead1] I* intval
		break_report_two_val RegFr1ra $addr_num [string toupper [format "%08x" $intval]]
		transcribe stop
	    }		    
	}
		
	# Prueba si hay un breakpoint de lectura segn el dato del Read1
	if {$BpRegRead1DaEn == 1} {
	    
	    # Recuperacin de la direccin
	    set AddrRead1 00000000000[examine -value /micro_bloc/regfile_bloc/raddr1]
	    binary scan [binary format B16 $AddrRead1] S* addr_num
	    
	    # Recuperacin del dato
	    set DataOutRead1 [examine -value /micro_bloc/regfile_bloc/u0/mem($addr_num)]
	    binary scan [binary format B32 $DataOutRead1] I* intval
	    
	    # Transformacin del dato para poderlo comparar
	    set tempvar [format "%i" 0x$BpRegRead1Da]
	    set tempvar [string toupper [format "%08x" $tempvar]]
	    
	    # Prueba si las condiciones estn cumplidas y en ese caso llama
	    # la ventana Breakpoint Report antes de interrumpir la simulacin
	    if {[string compare [string toupper [format "%08x" $intval]] $tempvar] == 0} {
		break_report_two_val RegFr1rd $tempvar $addr_num
		transcribe stop
	    }		    
	}
		
	
	# Esactamente las mismas operaciones que para el breakpoint de lectura
	# del Read1, pero para el Read2.
	# Primero para el breakpoint de direccin
	if {$BpRegRead2AddrEn == 1} {
	    set AddrRead2 00000000000[examine -value /micro_bloc/regfile_bloc/raddr2]
	    binary scan [binary format B16 $AddrRead2] S* addr_num
	    
	    if {[string compare $addr_num $BpRegRead2Addr] == 0} {		
		set DataOutRead2 [examine -value /micro_bloc/regfile_bloc/u1/mem($addr_num)]
		binary scan [binary format B32 $DataOutRead2] I* intval
		break_report_two_val RegFr2ra $addr_num [string toupper [format "%08x" $intval]]
		transcribe stop
	    }		    
	}
	
	# Luego para el breakpoint de datos
	if {$BpRegRead2DaEn == 1} {
	    set AddrRead2 00000000000[examine -value /micro_bloc/regfile_bloc/raddr2]
	    binary scan [binary format B16 $AddrRead2] S* addr_num
	    
	    set DataOutRead2 [examine -value /micro_bloc/regfile_bloc/u1/mem($addr_num)]
	    
	    binary scan [binary format B32 $DataOutRead2] I* intval
	    set tempvar [format "%i" 0x$BpRegRead2Da]
	    set tempvar [string toupper [format "%08x" $tempvar]]

	    if {[string compare [string toupper [format "%08x" $intval]] $tempvar] == 0} {
		break_report_two_val RegFr2rd $tempvar $addr_num
		transcribe stop
	    }		    
	}
    }
}


#
# Procedura que espera una lectura o una escritura en la Ram para actulizar
# la visualizacin o parar la simulacin en el caso que las condiciones
# de breakpoint sean cumplidas.
#
proc draw_ram {} {
    global BpRamWriteAddrEn BpRamWriteAddr RamArray Viewram DataInRam AddrRam BpRamWriteDaEn BpRamWriteDa hexaval BpRamReadAddrEn BpRamReadAddr BpRamReadDaEn BpRamReadDa DataOutRam BeginRam VariationRam Ramsize VariationRam BeginRam

    # Inicialisacion del porcentage de una linia en la barra de desplazamiento
    calcpercentram

    # Supresin del derecho de escritura
    .main_window.i.ram.data configure -state disabled

    set DataInRam initialisation
    set AddrRam initialisation
    set hexaval initialisation
    
    # Espera que el flanco del reloj sea descendiente. Prueba si el
    # microprocesador quiere escribir.
    when {/ram_bloc/bloc_memoria/clk = '0'} {
	if {[string compare [examine -value /ram_bloc/bloc_memoria/we] 1] == 0} {		    
	    # Recuperacin de la direccin
	    set AddrRam 000000[examine -value /ram_bloc/bloc_memoria/addr]
	    binary scan [binary format B16 $AddrRam] S* addr_num
	    
	    # Recuperacin del dato
	    set DataInRam [examine -value /ram_bloc/datain]
	    
	    # Escritura de la linea en la ventana de la Ram
	    write_line_Ram $addr_num
	    
	    # Prueba de la validez del dato
	    if {[string compare $DataInRam ZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZ] != 0} {		
		# Transformacin del dato para poder ser comparado
		binary scan [binary format B32 $DataInRam] I* intval
		set hexaval [string toupper [format "%08x" $intval]]
	    }

	    # Prueba si el breakpoint de direccin esta activo y si las
	    # condiciones estn cumplidas, para la simulacin abriendo la
	    # ventana de Breakpoint Report
	    if {$BpRamWriteAddrEn == 1} {
		if {[string compare $addr_num $BpRamWriteAddr] == 0} {
		    break_report_two_val Ramwa $addr_num $hexaval
		    transcribe stop
		}		
	    }
	    
	    # Prueba si el breakpoint de datos esta activo y si las
	    # condiciones estn cumplidas, para la simulacin abriendo la
	    # ventana de Breakpoint Report
	    if {$BpRamWriteDaEn == 1} {
		set tempvar [format "%i" 0x$BpRamWriteDa]
		if {[string compare $hexaval [string toupper [format "%08x" $tempvar]]] == 0} {
		    break_report_two_val Ramwd $hexaval $addr_num
		    transcribe stop
		}	
	    }
	}
    }
    
    # Prueba si el microprocesador quiere leer un dato de la Ram, efectua otra
    # vez la prueba 2ns ms tarde para estar seguro el OE y el WE no hayan
    # cambiado al mismo tiempo y la deteccin haya sido mala.
    set DataOutRam initialisation
    when {/oe_ram = '1' and /ram_bloc/we = '0'} {
	when {$now == 2ns and /oe_ram = '1' and /ram_bloc/we = '0'} {
	    
	    # Prueba de la validez del dato
	    if {[string compare $DataOutRam ZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZ] != 0} {
		# Prueba si hay un breakpoint de lectura segn la direccin
		if {$BpRamReadAddrEn == 1} {
		    # Recupera la direccin
		    set AddrRam 000000[examine -value /ram_bloc/bloc_memoria/addr]
		    binary scan [binary format B16 $AddrRam] S* addr_num
		    
		    # Prueba si las condiciones estan cumplidas y si es el caso,
		    # para la simulacin y llama la ventana Breakpoint Report
		    if {[string compare $addr_num $BpRamReadAddr] == 0} {
			set DataOutRam [examine -value /ram_bloc/bloc_memoria/mem($addr_num)]
			binary scan [binary format B32 $DataOutRam] I* intval
			break_report_two_val Ramra $addr_num [string toupper [format "%08x" $intval]]
			transcribe stop
		    }
		}
		
		# Mismo proceso que para el breakpoint de lectura segn la
		# direccin pero para el breakpoint de lectura segn los datos
		if {$BpRamReadDaEn == 1} {
		    set AddrRam 000000[examine -value /ram_bloc/bloc_memoria/addr]
		    binary scan [binary format B16 $AddrRam] S* addr_num
		    set DataOutRam [examine -value /ram_bloc/bloc_memoria/mem($addr_num)]
		    binary scan [binary format B32 $DataOutRam] I* intval
		    set tempvar [format "%i" 0x$BpRamReadDa]
		    set tempvar [string toupper [format "%08x" $tempvar]]
		    if {[string compare [string toupper [format "%08x" $intval]] $tempvar] == 0} {
			break_report_two_val Ramrd $tempvar $addr_num
			transcribe stop
		    }	
		}
	    }
	}
    }
}


#
# Procedura que espera un cambio de seal en las variables situadas en la
# parte inferior de la pantalla principal, para actulizarlas.
# Segn la variable, tambin prueba si tiene que parar la simulacin o no.
#
proc wait_signal { } {
    global Instr BpInstrEn BpInstrDa StepPC

    # Espera un cambio de instruccin
    when {/micro_bloc/micro_bloc/microcontroller/instr_in} {

	# Recuperacin de la instruccin y de sus diferentes escrituras en
	# el interpretador
	set code [examine -value /micro_bloc/micro_bloc/microcontroller/instr_in]	
	set details [interpreter $code]
       
	# Actualizacin de la visualizacin
	instr_update
	
	# Comparacin para efectuar un breakpoint si las condiciones estn
	# cumplidas
	if {$BpInstrEn == 1} {			
	    if {[string compare $BpInstrDa [lindex $details 0]] == 0} {
		break_report_one_val Instr [lindex $details 0]
		transcribe stop
	    }	    
	}	
    }

    
    # Espera un cambio del contador del PC
    when {/micro_bloc/micro_bloc/microcontroller/memPC} {

	# Actualizacin de la visualizacin
	PC_update
	
	if {$StepPC == 1} {
	    set StepPC 0
	    transcribe stop
	}

	# Comparacin para efectuar un breakpoint si las condiciones estn
	# cumplidas
	global RomBp vieuxPC
 	if {$RomBp($vieuxPC) == 1} {
	    break_report_one_val PC $vieuxPC
	    transcribe stop
 	}
    }
    
    # Espera un cambio de la mascara de interrupcion
    when {/micro_bloc/micro_bloc/microcontroller/CONTROL_INTERRUPCIONS/mascara} {
	# Actualizacin de la visualizacin
	mascara_update
    }

    # Espera un cambio del registro SP    
    when {/micro_bloc/micro_bloc/microcontroller/stack_pointer/SP} {
	# Actualizacin de la visualizacin
	register_32 /micro_bloc/micro_bloc/microcontroller/stack_pointer/SP up.center.sp
    }

    # Espera un cambio del registro SR1
    when {/micro_bloc/micro_bloc/microcontroller/ALUshifter/A} {
	# Actualizacin de la visualizacin
	register_32 /micro_bloc/micro_bloc/microcontroller/ALUshifter/A up.left.sr1
    }

    # Espera un cambio del registro SR2
    when {/micro_bloc/micro_bloc/microcontroller/ALUshifter/B} {
	# Actualizacin de la visualizacin
	register_32 /micro_bloc/micro_bloc/microcontroller/ALUshifter/B up.left.sr2
    }

    # Espera un cambio del registro DR
    when {/micro_bloc/micro_bloc/microcontroller/ALUshifter/Result} {
	# Actualizacin de la visualizacin
	register_32 /micro_bloc/micro_bloc/microcontroller/ALUshifter/Result up.left.dr
    }

    # Espera un cambio de AHBI IN HADDR   
    when {/micro_bloc/micro_bloc/sahbi_in_haddr} {
	# Actualizacin de la visualizacin
	register_20 /micro_bloc/micro_bloc/sahbi_in_haddr up.center.ahbiinhaddr
    }

    # Espera un cambio de AHBI OUT HADDR   
    when {/micro_bloc/micro_bloc/sahbi_out_haddr} {
	# Actualizacin de la visualizacin
	register_32 /micro_bloc/micro_bloc/sahbi_out_haddr up.center.ahbiouthaddr
    }

    # Espera un cambio de AHB OUT DATA 
    when {/micro_bloc/micro_bloc/sahb_out_data} {
	# Actualizacin de la visualizacin
	register_32 /micro_bloc/micro_bloc/sahb_out_data up.center.ahboutdata
    }

    # Espera un cambio de AHB IN DATA 
    when {/micro_bloc/micro_bloc/sahb_in_data} {
	# Actualizacin de la visualizacin
	register_32 /micro_bloc/micro_bloc/sahb_in_data up.center.ahbindata
    }

    # Espera un cambio de AHB IN SEL
    when {/micro_bloc/micro_bloc/sahbi_in_hsel} {
	# Actualizacin de la visualizacin
	.main_window.i.register.up.right.ahbinsel.v configure -text "[examine -value /micro_bloc/micro_bloc/sahbi_in_hsel]"
    }

    # Espera un cambio de AHB IN READY
    when {/micro_bloc/micro_bloc/sahbi_in_hready} {
	# Actualizacin de la visualizacin
	.main_window.i.register.up.right.ahbinready.v configure -text "[examine -value /micro_bloc/micro_bloc/sahbi_in_hready]"
    }

    # Espera un cambio de AHB IN WRITE
    when {/micro_bloc/micro_bloc/sahbi_in_hwrite} {
	# Actualizacin de la visualizacin
	.main_window.i.register.up.right.ahbinwrite.v configure -text "[examine -value /micro_bloc/micro_bloc/sahbi_in_hwrite]"
    }

    # Espera un cambio de AHB OUT SEL
    when {/micro_bloc/micro_bloc/sahbi_out_hsel} {
	# Actualizacin de la visualizacin
	.main_window.i.register.up.right.ahboutsel.v configure -text "[examine -value /micro_bloc/micro_bloc/sahbi_out_hsel]"
    }

    # Espera un cambio de AHB OUT READY
    when {/micro_bloc/micro_bloc/sahbi_out_hready} {
	# Actualizacin de la visualizacin
	.main_window.i.register.up.right.ahboutready.v configure -text "[examine -value /micro_bloc/micro_bloc/sahbi_out_hready]"
    }

    # Espera un cambio de AHB OUT WRITE
    when {/micro_bloc/micro_bloc/sahbi_out_hwrite} {
	# Actualizacin de la visualizacin
	.main_window.i.register.up.right.ahboutwrite.v configure -text "[examine -value /micro_bloc/micro_bloc/sahbi_out_hwrite]"
    }
}


#
# Procedura que recupera un registro de 32 bits y actualiza su visualizacin
# Sus parametros son la direccin de la seal y el nombre del campo de
# visualizacin que hay que actualizar.
#
proc register_32 { obj ext } {
    global Viewdata
    
    # Controla la validez del dato
    if {[examine -value $obj] == "UUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUU"} {
	.main_window.i.register.$ext.v configure -text "No Data"

    } elseif {[examine -value $obj] == "ZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZ"} {
	switch $Viewdata {
	    Binary {.main_window.i.register.$ext.v configure -text "ZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZ"}
	    Octal {.main_window.i.register.$ext.v configure -text "ZZZZZZZZZZZ"} 
	    Hexadecimal {.main_window.i.register.$ext.v configure -text "ZZZZZZZZ"}
	    Decimal {.main_window.i.register.$ext.v configure -text "Z"}
	}

	# Transforma el dato en los diferentes formatos y actualiza con el que
	# corresponda.
    } else {
	binary scan [binary format B32 [examine -value $obj]] I* count_val
	set hexaval [string toupper [format "%08x" $count_val]]
	set octalval [string toupper [format "%011o" $count_val]]
	set intval [format "%u" $count_val]
	switch $Viewdata {
	    Binary {.main_window.i.register.$ext.v configure -text [examine -value $obj]}
	    Octal {.main_window.i.register.$ext.v configure -text $octalval} 
	    Hexadecimal {.main_window.i.register.$ext.v configure -text $hexaval}
	    Decimal {.main_window.i.register.$ext.v configure -text $intval}
	}
    }  
} 


#
# Procedura que se comporta esactamente como register_32 pero para registros
# de 20 bits
#
proc register_20 { obj ext } {
    global Viewdata
    
    if {[examine -value $obj] == "UUUUUUUUUUUUUUUUUUUU"} {
	.main_window.i.register.$ext.v configure -text "No Data"

    } elseif {[examine -value $obj] == "ZZZZZZZZZZZZZZZZZZZZ"} {
	switch $Viewdata {
	    Binary {.main_window.i.register.$ext.v configure -text "ZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZ"}
	    Octal {.main_window.i.register.$ext.v configure -text "ZZZZZZZZZZZ"} 
	    Hexadecimal {.main_window.i.register.$ext.v configure -text "ZZZZZZZZ"}
	    Decimal {.main_window.i.register.$ext.v configure -text "Z"}
	}

    } else {
	set val [examine -value $obj]
	binary scan [binary format B32 [format "%032s" $val]] B* val
	binary scan [binary format B32 $val] I* count_val
	set hexaval [string toupper [format "%08x" $count_val]]
	set octalval [string toupper [format "%011o" $count_val]]
	set intval [format "%u" $count_val]
	switch $Viewdata {
	    Binary {.main_window.i.register.$ext.v configure -text $val}
	    Octal {.main_window.i.register.$ext.v configure -text $octalval} 
	    Hexadecimal {.main_window.i.register.$ext.v configure -text $hexaval}
	    Decimal {.main_window.i.register.$ext.v configure -text $intval}
	}
    }   
} 


#
# Procedura de actualizacin de la mascara de interrupcin
#
proc mascara_update {} {
    
    if {[examine -value /micro_bloc/micro_bloc/microcontroller/CONTROL_INTERRUPCIONS/mascara] == "UUUUU"} {
	.main_window.i.register.up.left.im.v configure -text "No Data"
    } else {
	binary scan [binary format B5 [examine -value /micro_bloc/micro_bloc/microcontroller/CONTROL_INTERRUPCIONS/mascara]] B5 count_val
	.main_window.i.register.up.left.im.v configure -text $count_val
    }	
}


#
# Procedura de actualizacin de la instruccin y su detalle
#
proc instr_update {} {
    # Recuperacin del codigo de la instrucin
    set code [examine -value /micro_bloc/micro_bloc/microcontroller/instr_in]
    # Recuperacin del detalle y el mnemonic de la instruccin por el
    # interpretador y actualizacin
    set details [interpreter $code]
    .main_window.i.register.up.left.op.v configure -text "[lindex $details 2]"
    .main_window.i.register.bottom.op.v configure -text "[lindex $details 1]"
}


#
# Procedura de actualizacin del contador del PC
#
proc PC_update {} {
    global vieuxPC RomBp RomLine
    
    # Actualizacin de la visualizacin
    register_32 /micro_bloc/micro_bloc/microcontroller/memPC up.left.pc
    
    # Actualiza la posicin de la ventana de la Rom
    if {[examine -value /micro_bloc/micro_bloc/microcontroller/memPC] != "UUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUU"} {
	# Recuperacin del valor del PC
	binary scan [binary format B32 [examine -value /micro_bloc/micro_bloc/microcontroller/memPC]] I* count_val
	
	# Creacin de las imagenes que aparecen para indicar la linea del PC e indican
	# un breakpoint
 	set ImageNameLine [pwd]/Interface/Images/systemc_du.gif
 	set pictline [image create photo PCline -file $ImageNameLine]
	set ImageName [pwd]/Interface/Images/virt_du.gif
	set pict [image create photo Bp -file $ImageName]
	# Derecho de escritura
 	.main_window.i.rom.data configure -state normal
	
	# Prueba si el PC a cambiado
	if {$vieuxPC != $count_val} {
	    # Prueba si hay un breakpoint que volver a dibujar en la antigua linea del PC
	    if {$RomBp($vieuxPC) == 1} {		
		.main_window.i.rom.data delete [expr {$vieuxPC+1}].0
		.main_window.i.rom.data image create [expr {$vieuxPC+1}].0 -image $pict
	    } else {
		.main_window.i.rom.data delete [expr {$vieuxPC+1}].0
		.main_window.i.rom.data insert [expr {$vieuxPC+1}].0 "  "
	    }

	    # Prueba si hay un Breakpoint en la nueva linea del PC
	    if {$RomBp($count_val) == 1} {
		.main_window.i.rom.data delete [expr {$count_val+1}].0
		.main_window.i.rom.data image create [expr {$count_val+1}].0 -image $pictline
	    } else {
		.main_window.i.rom.data delete [expr {$count_val+1}].0 [expr {$count_val+1}].2
		.main_window.i.rom.data image create [expr {$count_val+1}].0 -image $pictline
	    }
	    set RomLine($vieuxPC) 0
	    set RomLine($count_val) 1
	    
	    # Prueba si el PC no ha cambiado y si el indicador de linea no est dibujado
	} else {
	    if {$RomLine($vieuxPC) == 0} {
		.main_window.i.rom.data delete [expr {$count_val+1}].0 [expr {$count_val+1}].2
		.main_window.i.rom.data image create [expr {$count_val+1}].0 -image $pictline
		set RomLine($vieuxPC) 1
	    }  
	}
	
	# Supresin del derecho de escritura
 	.main_window.i.rom.data configure -state disabled
		
	set vieuxPC $count_val
	
	# Movimiento de la ventana de la Rom
	.main_window.i.rom.data yview scroll -1024 units
	.main_window.i.rom.data yview scroll $count_val units	
    }
}


#
# Funcin que permite aadir la linea que se escribe en la visualizacin de la
# Ram. El parametro de entrada solo es la linea en la que se quiere escribir
# porque los datos estn directamente introducidos en la variable global
# DataInRam antes de llamar esta funcin.
# La escritura se efectua teniendo en cuenta los parametros de visualizacin
# de la Ram.
#
proc write_line_Ram { line_write } {
    global RamArray DataInRam BeginRam VariationRam Viewram

    # Derecho de escritura
    .main_window.i.ram.data configure -state normal
    
    # Verifica la validez del dato
    if {[string compare $DataInRam ZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZ] != 0} {

	# Transformacin del formato del dato e insercin en el array RamArray
	binary scan [binary format B32 $DataInRam] I* intval
	set hexaval [string toupper [format "%08x" $intval]]	
	foreach opcion {Binary Octal Hexadecimal Decimal} {
	    switch $opcion {
		Binary {set RamArray($line_write,$opcion) $DataInRam}
		Octal {set RamArray($line_write,$opcion) [string toupper [format "%011o" $intval]]} 
		Hexadecimal {set RamArray($line_write,$opcion) $hexaval}
		Decimal {set RamArray($line_write,$opcion) [format "%010u" $intval]}
	    }
	}
	
	# Borramiento de la linea y escritura del nuevo valor, respetando la
	# configuracin de la visualizacin de la Ram
	if {[expr {$BeginRam <= $line_write}] && [expr {$line_write < [expr {$BeginRam + $VariationRam}]}]} {
	    set line [format "%04u" $line_write]
	    .main_window.i.ram.data delete [expr {$line_write - $BeginRam + 1}].0 [expr {$line_write - $BeginRam + 2}].0
	    .main_window.i.ram.data insert [expr {$line_write - $BeginRam + 1}].0 "$line $RamArray($line_write,$Viewram)\n"
	    
	    # Actualizacin de la ventana de la Ram
	    .main_window.i.ram.data yview scroll -$VariationRam units
	    .main_window.i.ram.data yview scroll [expr {$line_write-$BeginRam}] units
	}
    } 
    # Supresin del derecho de escritura
    .main_window.i.ram.data configure -state disabled   
}


#
# Funcin que permite aadir la linea que se escribe en la visualizacin del
# banco de registros. El parametro de entrada solo es la linea en la que se
# quiere escribir porque los datos estn directamente introducidos en la
# variable global DataInReg antes de llamar esta funcin.
#
proc write_line_BReg { line_write } {
    global RegArray DataInReg Viewbr

    # Derecho de escritura
    .main_window.i.regfile.data configure -state normal
    
    # Transformacin del dato en los diferentes formatos posibles e
    # introduccin en el array RegArray
    binary scan [binary format B32 $DataInReg] I* intval    
    foreach opcion {Binary Octal Hexadecimal Decimal} {
	switch $opcion {
	    Binary {set RegArray($line_write,$opcion) $DataInReg}
	    Octal {set RegArray($line_write,$opcion) [string toupper [format "%011o" $intval]]} 
	    Hexadecimal {set RegArray($line_write,$opcion) [string toupper [format "%08x" $intval]]}
	    Decimal {set RegArray($line_write,$opcion) [format "%010u" $intval]}
	}
    }
    
    # Borramiento de la linea y escritura del nuevo valor.
    .main_window.i.regfile.data delete [expr {$line_write + 1}].0 [expr {$line_write + 2}].0
    set line [format "%02u" $line_write]
    .main_window.i.regfile.data insert [expr {$line_write + 1}].0 "$line $RegArray($line_write,$Viewbr)\n"
    
    # Supresin del derecho de escritura
    .main_window.i.regfile.data configure -state disabled
    
    # Actualizacin de la ventana del banco de registros
    .main_window.i.regfile.data yview scroll -32 units
    .main_window.i.regfile.data yview scroll $line_write units
}

