/*
 * Copyright (c) 2009 Xilinx, Inc.  All rights reserved.
 *
 * Xilinx, Inc.
 * XILINX IS PROVIDING THIS DESIGN, CODE, OR INFORMATION "AS IS" AS A
 * COURTESY TO YOU.  BY PROVIDING THIS DESIGN, CODE, OR INFORMATION AS
 * ONE POSSIBLE   IMPLEMENTATION OF THIS FEATURE, APPLICATION OR
 * STANDARD, XILINX IS MAKING NO REPRESENTATION THAT THIS IMPLEMENTATION
 * IS FREE FROM ANY CLAIMS OF INFRINGEMENT, AND YOU ARE RESPONSIBLE
 * FOR OBTAINING ANY RIGHTS YOU MAY REQUIRE FOR YOUR IMPLEMENTATION.
 * XILINX EXPRESSLY DISCLAIMS ANY WARRANTY WHATSOEVER WITH RESPECT TO
 * THE ADEQUACY OF THE IMPLEMENTATION, INCLUDING BUT NOT LIMITED TO
 * ANY WARRANTIES OR REPRESENTATIONS THAT THIS IMPLEMENTATION IS FREE
 * FROM CLAIMS OF INFRINGEMENT, IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE.
 *
 */

#ifndef __PLATFORM_CONFIG_H_
#define __PLATFORM_CONFIG_H_

#include "xparameters.h"

/* ethernet controller base address */
#ifdef XPAR_AXIETHERNET_0_BASEADDR
#define PLATFORM_EMAC_BASEADDR  XPAR_AXIETHERNET_0_BASEADDR
#elif XPAR_LLTEMAC_0_BASEADDR
#define PLATFORM_EMAC_BASEADDR  XPAR_LLTEMAC_0_BASEADDR
#elif XPAR_ETHERNET_BASEADDR
#define PLATFORM_EMAC_BASEADDR  XPAR_ETHERNET_BASEADDR
#elif XPAR_EMACLITE_0_BASEADDR
#define PLATFORM_EMAC_BASEADDR XPAR_EMACLITE_0_BASEADDR
#else
#ifdef XPAR_XEMACPS_0_BASEADDR
#ifdef XPAR_XEMACPS_1_BASEADDR
#if XLWIP_CONFIG_EMAC_NUMBER == 0
#define PLATFORM_EMAC_BASEADDR XPAR_XEMACPS_0_BASEADDR
#else
#define PLATFORM_EMAC_BASEADDR XPAR_XEMACPS_1_BASEADDR
#endif
#else
#define PLATFORM_EMAC_BASEADDR XPAR_XEMACPS_0_BASEADDR
#endif
#elif XPAR_XEMACPS_1_BASEADDR
#ifdef XPAR_XEMACPS_0_BASEADDR
#if XLWIP_CONFIG_EMAC_NUMBER == 0
#define PLATFORM_EMAC_BASEADDR XPAR_XEMACPS_0_BASEADDR
#else
#define PLATFORM_EMAC_BASEADDR XPAR_XEMACPS_1_BASEADDR
#endif
#else
#define PLATFORM_EMAC_BASEADDR XPAR_XEMACPS_1_BASEADDR
#endif
#endif
#endif

#ifndef PLATFORM_EMAC_BASEADDR
#error "No Ethernet Interface Selected"
#endif

/* timer configuration */
#ifdef __MICROBLAZE__
#define PLATFORM_TIMER_BASEADDR XPAR_TMRCTR_0_BASEADDR
#define PLATFORM_TIMER_INTERRUPT_INTR XPAR_INTC_0_TMRCTR_0_VEC_ID
#define PLATFORM_TIMER_INTERRUPT_MASK (1 << PLATFORM_TIMER_INTERRUPT_INTR)
#endif

#ifndef __MICROBLAZE__
#define CACHEABLE_REGION_MASK 0xc0000001
#endif

#endif

